/*
	<linux/compat/spinlock.h>

	compatibility spin lock macros

	$Id: spinlock.h,v 1.12 2003/06/16 13:31:07 fedorov Exp $

	compiled from kernel sources by Dmitry Fedorov, fedorov@inp.nsk.su
*/

#ifndef  _LINUX_COMPAT_SPINLOCK_H
# define _LINUX_COMPAT_SPINLOCK_H

# include <linux/compat/version.h>
# include <linux/compat/config.h>
# include <linux/compat/compiler.h>


# if LINUX_VERSION_CODE <= KERNEL_VERSION(2,1,0)

#  ifndef CONFIG_SMP

/* Gcc-2.7.x has a nasty bug with empty initializers. */
#   if GCC_VERSION_CODE >= GCC_VERSION(2,8,0)
     typedef struct { int empty[0]; } spinlock_t;
#    define SPIN_LOCK_UNLOCKED (spinlock_t) { }
#   else
     typedef struct { int gcc_is_buggy; } spinlock_t;
#    define SPIN_LOCK_UNLOCKED (spinlock_t) { 0 }
#   endif

#   define spin_lock_init(lock)   do { } while(0)
#   define spin_lock(lock)        do { } while(0)
#   define spin_trylock(lock)     (1)
#   define spin_unlock_wait(lock) do { } while(0)
#   define spin_unlock(lock)      do { } while(0)
#   define spin_lock_irq(lock)    cli()
#   define spin_unlock_irq(lock)  sti()

#   define spin_lock_irqsave(lock, flags) \
        do { save_flags(flags); cli(); } while (0)

#   define spin_unlock_irqrestore(lock, flags) \
        restore_flags(flags)

/*
 * Read-write spinlocks, allowing multiple readers
 * but only one writer.
 *
 * NOTE! it is quite common to have readers in interrupts
 * but no interrupt writers. For those circumstances we
 * can "mix" irq-safe locks - any writer needs to get a
 * irq-safe write-lock, but readers can get non-irqsafe
 * read-locks.
 *
 * Gcc-2.7.x has a nasty bug with empty initializers.
 */
#   if GCC_VERSION_CODE >= GCC_VERSION(2,8,0)
     typedef struct { int empty[0]; } rwlock_t;
#    define RW_LOCK_UNLOCKED (rwlock_t) { }
#   else
     typedef struct { int gcc_is_buggy; } rwlock_t;
#    define RW_LOCK_UNLOCKED (rwlock_t) { 0 }
#   endif

#   define read_lock(lock)        do { } while(0)
#   define read_unlock(lock)      do { } while(0)
#   define write_lock(lock)       do { } while(0)
#   define write_unlock(lock)     do { } while(0)
#   define read_lock_irq(lock)    cli()
#   define read_unlock_irq(lock)  sti()
#   define write_lock_irq(lock)   cli()
#   define write_unlock_irq(lock) sti()

#   define read_lock_irqsave(lock, flags) \
        do { save_flags(flags); cli(); } while (0)

#   define read_unlock_irqrestore(lock, flags) \
        restore_flags(flags)

#   define write_lock_irqsave(lock, flags)	\
        do { save_flags(flags); cli(); } while (0)

#   define write_unlock_irqrestore(lock, flags) \
        restore_flags(flags)

#  else  /*  def CONFIG_SMP */

#   error 2.0.x SMP is not supported

#  endif /* ndef CONFIG_SMP */

# else   /* LINUX_VERSION_CODE > KERNEL_VERSION(2,1,0) */
#  if LINUX_VERSION_CODE >= KERNEL_VERSION(2,2,18)
#   include <linux/spinlock.h>
#  else
#   include   <asm/spinlock.h>
#  endif
# endif


# if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,0)
#  include <linux/compat/interrupt.h>
#  define   spin_lock_bh(lock) do { start_bh_atomic(); spin_lock(lock); } while(0)
#  define spin_unlock_bh(lock) do { spin_unlock(lock); end_bh_atomic(); } while(0)
# endif

#endif	/* _LINUX_COMPAT_SPINLOCK_H */

