/*
	<linux/compat/smp_lock.h>

	compatibility smp_lock macros

	$Id: smp_lock.h,v 1.9 2001/12/16 10:10:02 fedorov Exp $

	compiled from kernel sources by Dmitry Fedorov, fedorov@inp.nsk.su
*/

#ifndef  _LINUX_COMPAT_SMPLOCK_H
# define _LINUX_COMPAT_SMPLOCK_H

# include <linux/compat/version.h>
# include <linux/compat/config.h>


# if LINUX_VERSION_CODE <= KERNEL_VERSION(2,1,0)
#  ifndef CONFIG_SMP
#   define   lock_kernel()                  do { } while(0)
#   define unlock_kernel()                  do { } while(0)
#   define   release_kernel_lock(task, cpu) do { } while(0)
#   define reacquire_kernel_lock(task)      do { } while(0)
#  else
#   error 2.0.x SMP is not supported
#  endif
# else
#  include <linux/compat/interrupt.h>	/* fix broken headers */
#  include <linux/smp_lock.h>
# endif


/* lock_kernel()/unlock_kernel() on syscall entry/exit          */
/* 2.4 does not do it, 2.2 does it itself, 2.0 does not need it */
# if LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,0)
#  define   LOCK_KERNEL_COMPAT()   lock_kernel()
#  define UNLOCK_KERNEL_COMPAT() unlock_kernel()
# else
#  define   LOCK_KERNEL_COMPAT()
#  define UNLOCK_KERNEL_COMPAT()
# endif


#endif	/* _LINUX_COMPAT_SMPLOCK_H */

