/*
	<linux/compat/sched.h>

	some compatibility macros for linux/sched.h

	compiled from kernel sources by Dmitry Fedorov, fedorov@inp.nsk.su

	$Id: sched.h,v 1.20 2001/12/18 14:24:42 fedorov Exp $
*/

#ifndef  _LINUX_COMPAT_SCHED_H
# define _LINUX_COMPAT_SCHED_H

# include <linux/compat/version.h>
# include <linux/compat/null.h>
# include <linux/compat/config.h>
# include <linux/sched.h>


# if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,57)
#  define signal_pending(p)  ((p)->signal & ~(p)->blocked)
# endif


# if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,110)
#  define NEED_RESCHED (need_resched)
# else
#  define NEED_RESCHED (current->need_resched)	/* need lock? $$$ */
# endif


# if LINUX_VERSION_CODE < KERNEL_VERSION(2,2,18)

#  define __set_task_state(tsk, state_value)		\
		do { (tsk)->state = (state_value); } while (0)

#  define __set_current_state(state_value)			\
		do { current->state = (state_value); } while (0)

#  ifdef CONFIG_SMP
#   include <linux/compat/system.h>	/* set_mb() */

#   define set_task_state(tsk, state_value)		\
		set_mb((tsk)->state, (state_value))

#   define set_current_state(state_value)		\
		set_mb(current->state, (state_value))

#  else /* !def CONFIG_SMP */

#   define set_task_state(tsk, state_value)		\
		__set_task_state((tsk), (state_value))

#   define set_current_state(state_value)		\
		__set_current_state(state_value)

#  endif /* CONFIG_SMP */
# endif	 /* LINUX_VERSION_CODE < KERNEL_VERSION(2,2,18) */


# ifndef  __wait_event
#  define __wait_event(wq, condition) 					\
do {									\
	wait_queue_t __wait;						\
	init_waitqueue_entry(&__wait, current);				\
									\
	add_wait_queue(&wq, &__wait);					\
	for (;;) {							\
		set_current_state(TASK_UNINTERRUPTIBLE);		\
		if (condition)						\
			break;						\
		schedule();						\
	}								\
	current->state = TASK_RUNNING;					\
	remove_wait_queue(&wq, &__wait);				\
} while (0)
# endif

# ifndef  wait_event
#  define wait_event(wq, condition) 					\
do {									\
	if (condition)	 						\
		break;							\
	__wait_event(wq, condition);					\
} while (0)
# endif


# ifndef  __wait_event_interruptible
#  define __wait_event_interruptible(wq, condition, ret)			\
do {									\
	wait_queue_t __wait;						\
	init_waitqueue_entry(&__wait, current);				\
									\
	add_wait_queue(&wq, &__wait);					\
	for (;;) {							\
		set_current_state(TASK_INTERRUPTIBLE);			\
		if (condition)						\
			break;						\
		if (!signal_pending(current)) {				\
			schedule();					\
			continue;					\
		}							\
		ret = -ERESTARTSYS;					\
		break;							\
	}								\
	current->state = TASK_RUNNING;					\
	remove_wait_queue(&wq, &__wait);				\
} while (0)
# endif

# ifndef  wait_event_interruptible
#  define wait_event_interruptible(wq, condition)				\
({									\
	int __ret = 0;							\
	if (!(condition))						\
		__wait_event_interruptible(wq, condition, __ret);	\
	__ret;								\
})
# endif


# if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,0)
#  define wake_up_interruptible_all(wqh) wake_up_interruptible(wqh)
# endif


# if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,0)
#  define  TASK_UTIME(task) (task)->utime
#  define  TASK_STIME(task) (task)->stime
#  define TASK_CUTIME(task) (task)->cutime
#  define TASK_CSTIME(task) (task)->cstime
# else
#  define  TASK_UTIME(task) (task)->times.tms_utime
#  define  TASK_STIME(task) (task)->times.tms_stime
#  define TASK_CUTIME(task) (task)->times.tms_cutime
#  define TASK_CSTIME(task) (task)->times.tms_cstime
# endif



# if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,127)
#  define MAX_SCHEDULE_TIMEOUT	LONG_MAX

/* returns rest of timer */
long schedule_timeout(long timeout);

#  include <linux/compat/wait.h>	/* wait_queue_head_t */

/* returns rest of timer */
long interruptible_sleep_on_timeout(wait_queue_head_t* p, long timeout);

# endif



/* + unstable names */
/* Open file table structure. */

/* returns -EMFILE if amount of files exceeded or fd arg. */
extern inline int check_max_fd(struct files_struct* files, int fd)
{
	return
# if   LINUX_VERSION_CODE >= KERNEL_VERSION(2,2,12)
		(fd >= files->max_fdset || fd >= files->max_fds)
# elif LINUX_VERSION_CODE >  KERNEL_VERSION(2,1,0)
		(fd >= files->max_fds)
# else	/* 2.0.x */
		(fd >= NR_OPEN)
# endif
		? -EMFILE : fd;
}


# if LINUX_VERSION_CODE >= KERNEL_VERSION(2,0,2)
extern inline ulong open_fds_bits(struct files_struct* files, size_t fd_set_nr)
{
#  if LINUX_VERSION_CODE >= KERNEL_VERSION(2,2,12)
	return files->open_fds->fds_bits[fd_set_nr];
#  else
	return files->open_fds.fds_bits[fd_set_nr];
#  endif
}
# else
ulong open_fds_bits(struct files_struct* files, size_t fd_set_nr);
# endif

/* - unstable names */


#endif	/* _LINUX_COMPAT_SCHED_H */

