/*
	<linux/compat/prefetch.h>

	compatibility generic cache management functions.

	compiled from kernel sources by Dmitry Fedorov, fedorov@inp.nsk.su

	$Id: prefetch.h,v 1.0 2001/09/30 12:40:01 fedorov Exp $
*/

#ifndef  _LINUX_COMPAT_PREFETCH_H
# define _LINUX_COMPAT_PREFETCH_H

# include <linux/compat/version.h>

# if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,10)
   extern inline void prefetch (const void *x) {}
   extern inline void prefetchw(const void *x) {}
#  define   spin_lock_prefetch(x) prefetchw(x)
# else
#  include <linux/prefetch.h>
# endif

#endif	/* _LINUX_COMPAT_PREFETCH_H */

