/*
	<linux/compat/poll_select_wait.h>
	$Id: poll_select_wait.h,v 1.4 2001/09/30 12:49:13 fedorov Exp $

	poll/select_wait()

	(C) 2000 Dmitry A. Fedorov, fedorov@inp.nsk.su
	Copying policy: GNU GPL
*/

#ifndef  _LINUX_COMPAT_POLL_SELECT_WAIT_H
# define _LINUX_COMPAT_POLL_SELECT_WAIT_H


/* wait_queue_head_t, select_table, KERNEL_VERSION() */
# include <linux/compat/wait.h>

struct file;


# if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,23)
#  include <linux/compat/sched.h>	/* select_wait() */

typedef select_table poll_select_table_t;

extern inline void poll_select_wait(struct file* file,
	wait_queue_head_t* wqh, poll_select_table_t* pst)
{
	select_wait(wqh, pst);
}

# else	/* >= 2.1.23 */
#  include <linux/compat/poll.h>	/* poll_table, poll_wait() */

typedef   poll_table poll_select_table_t;

extern inline void poll_select_wait(struct file* file,
	wait_queue_head_t* wqh, poll_select_table_t* pst)
{
	poll_wait(file, wqh, pst);
}

# endif	/* <> 2.1.23 */


#endif	/* _LINUX_COMPAT_POLL_SELECT_WAIT_H */

