/*
	<linux/compat/module.h>

	some compatibility macros for linux/module.h

	for documentation see latest kernel sources.

	<linux/module.h> is the same for the version ranges:
	2.0.0  - 2.0.33
	2.0.34 - 2.0.39

	2.2.0  - 2.2.14
	2.2.15 - 2.2.17
	2.2.18 - 2.2.19

	2.4.0  - 2.4.1
	2.4.2  - 2.4.9
	2.4.10

	TO DO:
		THIS_MODULE (since 2.2.18);
		EXPORT_SYMBOL_GPL() in 2.4.10-ac2 and 2.4.11-pre2 onwards
		(modutils 2.4.10 supports GPL only exported symbols);

	(C) 2000,2001 Dmitry A. Fedorov, fedorov@inp.nsk.su

	$Id: module.h,v 1.12 2003/04/27 12:50:11 fedorov Exp $
*/

/*
Usage:

#include <linux/compat/module.h>

[...]

#define COMPAT_SYMTAB_NAME my_symbol_table_name
#include <linux/compat/symtab_begin.h>

EXPORT_SYMBOL(symbol1)        EXPORT_SYMBOL_END

[...]

EXPORT_SYMBOL(symbolN)        EXPORT_SYMBOL_END

#include <linux/compat/symtab_end.h>

[...]

int xx_init(void)
{
	[...]

	if ( (rc=register_chrdev(major, name, &xx_fops)) < 0 )
		{ ... }

	[...]

# ifdef COMPAT_REGISTER_SYMTAB_NEEDED
	if ( (rc=register_symtab( &xx_syms )) != 0 )
	{
		printk(KERN_ERR "register_symtab() error, errno=%d\n", -rc);
		unregister_chrdev(major, name);
		return rc;
	}
# endif

	[...]
}

*/



#ifndef  _LINUX_COMPAT_MODULE_H
# define _LINUX_COMPAT_MODULE_H

# include <linux/compat/version.h>

# if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,18)
#  undef MODVERSIONS	/* dont define Using_Versions */
# endif
# include <linux/module.h>


# if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,18)
#  define MODULE_AUTHOR(name)
#  define MODULE_DESCRIPTION(desc)
#  define MODULE_SUPPORTED_DEVICE(name)
#  define MODULE_PARM(var,type)
#  define MODULE_PARM_DESC(var,desc)
#
#  ifndef __GENDEPS__	/* my makefile's symbol. df */
#			/* don't cast sym argument or else genksyms failed */
#			/* to generate symbols properly			   */
#   define EXPORT_SYMBOL(sym)        X      (sym)
#   define EXPORT_SYMBOL_NOVERS(sym) XNOVERS(sym)
#   define EXPORT_SYMBOL_END ,
#  else
#   define EXPORT_SYMBOL(symbol)
#   define EXPORT_SYMBOL_NOVERS(symbol)
#   define EXPORT_SYMBOL_END
#  endif
#  define COMPAT_REGISTER_SYMTAB_NEEDED
#
#  define EXPORT_NO_SYMBOLS register_symtab(NULL) /* place at init_module() */
# else
#  define EXPORT_SYMBOL_END ;
#  define register_symtab(symtab)
#  undef  COMPAT_REGISTER_SYMTAB_NEEDED
# endif


# if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,10) && !defined MODULE_LICENSE
#  define MODULE_LICENSE(license)
# endif

# if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,0)
#  define MODULE_GENERIC_TABLE(gtype,name)
#  define MODULE_DEVICE_TABLE(type,name)
#
#  define SET_MODULE_OWNER(some_struct) do { } while (0)
# endif


# if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,0)
#  define COMPAT_MOD_INC_USE_COUNT MOD_INC_USE_COUNT
#  define COMPAT_MOD_DEC_USE_COUNT MOD_DEC_USE_COUNT
# else	/* no need to count - it is handled automatically */
#	/*	with owner field of file_operations       */
#  define COMPAT_MOD_INC_USE_COUNT
#  define COMPAT_MOD_DEC_USE_COUNT
#endif


#endif	/* _LINUX_COMPAT_MODULE_H */

