/*
	<linux/compat/malloc.h>
	$Id: malloc.h,v 1.1 2001/12/10 14:33:24 fedorov Exp $

	<linux/malloc.h> since 2.2.0 is just wrapper for <linux/slab.h>
	kfree_s disappeared from 2.4.x

	compiled from kernel sources by Dmitry Fedorov, fedorov@inp.nsk.su
*/

#ifndef  _LINUX_COMPAT_MALLOC_H
# define _LINUX_COMPAT_MALLOC_H

# include <linux/compat/version.h>

# if LINUX_VERSION_CODE >= KERNEL_VERSION(2,2,0)
#  include <linux/slab.h>
#
#  if LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,0)
#   define kfree_s(addr, size) kfree(addr)
#  endif
# else
#  include <linux/malloc.h>
# endif

#endif /* _LINUX_COMPAT_MALLOC_H */

