/*
	<linux/compat/list.h>

	compatibility for simple circular doubly linked list.

	for documentation see latest kernel sources.

	<linux/list.h> is the same for the version ranges:
	2.2.0  - 2.2.17
	2.2.18 - 2.2.19

	2.4.0  - 2.4.1
	2.4.2  - 2.4.9
	2.4.10
	2.4.12

	compiled from kernel sources by Dmitry Fedorov, fedorov@inp.nsk.su

	$Id: list.h,v 1.2 2001/10/21 10:32:04 fedorov Exp $
*/

#ifndef  _LINUX_COMPAT_LIST_H
# define _LINUX_COMPAT_LIST_H

# include <linux/compat/version.h>


# if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,45)

#  if defined(__KERNEL__) || defined(_LVM_H_INCLUDE)

    struct list_head {
	struct list_head *next, *prev;
    };

#   define LIST_HEAD(name) \
	struct list_head name = LIST_HEAD_INIT(name)

#   define INIT_LIST_HEAD(ptr) do { \
	(ptr)->next = (ptr); (ptr)->prev = (ptr); \
    } while (0)

    extern inline void __list_add(struct list_head * new,
	struct list_head * prev,
	struct list_head * next)
    {
	next->prev = new;
	new->next = next;
	new->prev = prev;
	prev->next = new;
    }

    extern inline void list_add(struct list_head *new, struct list_head *head)
    {
	__list_add(new, head, head->next);
    }

    extern inline void __list_del(struct list_head * prev,
				  struct list_head * next)
    {
	next->prev = prev;
	prev->next = next;
    }

    extern inline void list_del(struct list_head *entry)
    {
	__list_del(entry->prev, entry->next);
    }

    extern inline int list_empty(struct list_head *head)
    {
	return head->next == head;
    }

    extern inline
    void list_splice(struct list_head *list, struct list_head *head)
    {
	struct list_head *first = list->next;

	if (first != list) {
		struct list_head *last = list->prev;
		struct list_head *at = head->next;

		first->prev = head;
		head->next = first;

		last->next = at;
		at->prev = last;
	}
    }

#   define list_entry(ptr, type, member) \
	((type *)((char *)(ptr)-(unsigned long)(&((type *)0)->member)))

#  endif /* __KERNEL__ || _LVM_H_INCLUDE */

# else	/* >= 2.1.45 */

#  include <linux/list.h>

# endif	/* >= 2.1.45 */


# if defined(__KERNEL__) || defined(_LVM_H_INCLUDE)

#  if LINUX_VERSION_CODE < KERNEL_VERSION(2,2,18)

#   define LIST_HEAD_INIT(name) { &(name), &(name) }

     extern inline
     void list_add_tail(struct list_head *new, struct list_head *head)
     {
	__list_add(new, head->prev, head);
     }

#   define list_for_each(pos, head) \
	for (pos = (head)->next; pos != (head); pos = pos->next)

#  endif  /* < 2.2.18 */


#  if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,0)

    extern inline void list_del_init(struct list_head *entry)
    {
	__list_del(entry->prev, entry->next);
	INIT_LIST_HEAD(entry);
    }

#  endif  /* < 2.4.0 */


#  if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,10)

#   define list_for_each_safe(pos, n, head) \
	for (pos = (head)->next, n = pos->next; pos != (head); \
		pos = n, n = pos->next)

#  endif /* < 2.4.10 */

# endif /* __KERNEL__ || _LVM_H_INCLUDE */


#endif	/* _LINUX_COMPAT_LIST_H */

