/*
	<linux/compat/ioport.h>

	compatibility <linux/ioport.h> macros

	  check_mem_region
	request_mem_region
	release_mem_region

	compiled from kernel sources by Dmitry Fedorov, fedorov@inp.nsk.su

	$Id: ioport.h,v 1.1 2001/12/01 09:31:07 fedorov Exp $
*/

#ifndef   _LINUX_COMPAT_IOPORT_H
# define  _LINUX_COMPAT_IOPORT_H

# include <linux/compat/version.h>
# include <linux/ioport.h>


# if  LINUX_VERSION_CODE < KERNEL_VERSION(2,2,20) /* < 2.3.13 */

extern inline int    check_mem_region(ulong from, ulong extent) { return 0; }
extern inline void request_mem_region(ulong from, ulong extent, const char *name) {}
extern inline void release_mem_region(ulong from, ulong extent) {}

# endif


#endif   /* _LINUX_COMPAT_IOPORT_H */

