/*
	<linux/compat/io.h>

	compatibility <asm/io.h> macros

	ioremap, iounmap, ioremap_nocache,
	virt_to_phys, phys_to_virt, virt_to_bus, bus_to_virt,
	isa_{read,write}{b,w,l},
	isa_memcpy_{from,to}io, isa_memset_io, isa_check_signature

	to do: check_signature() for 2.0.x

	compiled from kernel sources by Dmitry Fedorov, fedorov@inp.nsk.su

	$Id: io.h,v 1.15 2001/10/22 05:36:45 fedorov Exp $
*/

#ifndef   _LINUX_COMPAT_IO_H
# define  _LINUX_COMPAT_IO_H

# include <linux/compat/version.h>

# include <asm/io.h>


# if  LINUX_VERSION_CODE <= KERNEL_VERSION(2,1,0)
#  if LINUX_VERSION_CODE <= KERNEL_VERSION(1,3,0)
#   define ioremap(offset,size)  ((char *)(offset))
#   define iounmap(addr)
#  else  /* 2.0.x */
#   include <linux/mm.h> /* vremap, vfree */
#   ifndef __i386__ /* This simple approach works for non-PC platforms. */
#    define ioremap(offset,size)  vremap(offset,size)
#    define iounmap(addr)         vfree(addr)
#   else  /* __i386__ */
     void* ioremap(unsigned long phys_addr, unsigned long size);
     void  iounmap(void* addr);
#   endif /* __i386__ */
#  endif  /* 2.0.x */
#  define ioremap_nocache(offset,size)  ioremap(offset,size)
# endif  /* <= 2.1.0 */


# if  LINUX_VERSION_CODE < KERNEL_VERSION(2,3,0)
#
#  define isa_readb(a)			readb(a)
#  define isa_readw(a)			readw(a)
#  define isa_readl(a)			readl(a)
#
#  define isa_writeb(b,a)		writeb(b,a)
#  define isa_writew(w,a)		writew(w,a)
#  define isa_writel(l,a)		writel(l,a)
#
#  define isa_memset_io(a,b,c)		memset_io((a),(b),(c))
#  define isa_memcpy_fromio(a,b,c)	memcpy_fromio((a),(b),(c))
#  define isa_memcpy_toio(a,b,c)	memcpy_toio((a),(b),(c))
#
#  define isa_check_signature(io_addr, signature, length)	\
	check_signature((io_addr), (signature), (length))
#
# endif	/* < 2.3.0 */


#endif   /* _LINUX_COMPAT_IO_H */

