/*
	<linux/compat/interrupt.h>

	compatibility <linux/interrupt.h> macros

	compiled from kernel sources by Dmitry Fedorov, fedorov@inp.nsk.su

	$Id: interrupt.h,v 1.6 2001/12/13 15:15:50 fedorov Exp $
*/

#ifndef  _LINUX_COMPAT_INTERRUPT_H
# define _LINUX_COMPAT_INTERRUPT_H

# include <linux/compat/version.h>

# include <linux/types.h>           /* ulong for cleaned asm/system.h                */
# include <linux/compat/system.h>   /* save/restore_flags, cli,sti for asm/softirq.h */
# include <linux/compat/spinlock.h> /* spin_*lock*() for asm/softirq.h               */
# include <linux/smp.h>             /* smp_processor_id() for asm/softirq.h          */
# include <linux/sched.h>           /* current and tast_struct for asm/smp.h         */

struct pt_regs;

# include <linux/interrupt.h>

# if LINUX_VERSION_CODE <= KERNEL_VERSION(2,1,0)
#  ifndef  in_interrupt
#   define in_interrupt()	(intr_count)
#  endif
# endif

#endif	/* _LINUX_COMPAT_INTERRUPT_H */

