/*
	<linux/compat/init.h>

	compatibility init section macros

	__init_text, __init_data, __init_func

	compiled from kernel sources by Dmitry Fedorov, fedorov@inp.nsk.su

	$Id: init.h,v 1.15 2001/09/05 11:19:52 fedorov Exp $
*/

#ifndef  _LINUX_COMPAT_INIT_H
# define _LINUX_COMPAT_INIT_H

# include <linux/compat/version.h>


# if LINUX_VERSION_CODE >= KERNEL_VERSION(2,1,16)
#  include <linux/init.h>
#  ifndef  __exit	/* 2.4 feature */
#   define __exit
#   define __exitdata
#  endif
# else
#  define __init
#  define __initdata
#  define __exit
#  define __exitdata
# endif

# ifndef  __devinit	/* CONFIG_HOTPLUG */
#  define __devinit     __init
#  define __devinitdata __initdata
#  define __devexit     __exit
#  define __devexitdata __exitdata
# endif


/* I like this names */
# define __init_text __init
# define __init_data __initdata
# define __exit_text __exit
# define __exit_data __exitdata

# define __dev_init_text __devinit
# define __dev_init_data __devinitdata
# define __dev_exit_text __devexit
# define __dev_exit_data __devexitdata


/* y is unique global name of module init function as it was before */
# ifdef module_init
#  define COMPAT_MODULE_INIT(x,y) module_init(x)
#  define COMPAT_MODULE_EXIT(x)   module_exit(x)
# else
#  ifdef MODULE
#   define COMPAT_MODULE_INIT(x,y) int     init_module(void) __attribute__((alias(#x)));
#   define COMPAT_MODULE_EXIT(x)   void cleanup_module(void) __attribute__((alias(#x)));
#  else
#   define COMPAT_MODULE_INIT(x,y) int y(void) __attribute__((alias(#x)));
#   define COMPAT_MODULE_EXIT(x)
#  endif
# endif


#endif	/* _LINUX_COMPAT_INIT_H */

