/*
	<linux/compat/hardirq.h>

	some compatibility <asm/hardirq.h> macros

	$Id: hardirq.h,v 1.7 2001/12/09 11:13:12 fedorov Exp $

	compiled from kernel sources by Dmitry Fedorov, fedorov@inp.nsk.su
*/

#ifndef  _LINUX_COMPAT_HARDIRQ_H
# define _LINUX_COMPAT_HARDIRQ_H

# include <linux/compat/version.h>
# include <linux/compat/config.h>

# if LINUX_VERSION_CODE >= KERNEL_VERSION(2,1,30)
#  include <asm/hardirq.h>
# else
#  ifndef CONFIG_SMP
#   ifndef  in_interrupt
#    include <linux/interrupt.h>
#    define in_interrupt() (intr_count)
#   endif
#  else  /*  def CONFIG_SMP */
#   error 2.0.x SMP is not supported
#  endif /* !def CONFIG_SMP */
# endif

#endif	/* _LINUX_COMPAT_HARDIRQ_H */

