/*
	<linux/compat/fs.h>

	compatibility <linux/fs.h> macros

	compiled from kernel sources by Dmitry Fedorov, fedorov@inp.nsk.su

	$Id: fs.h,v 1.18 2003/06/13 11:46:33 fedorov Exp $
*/

#ifndef  _LINUX_COMPAT_FS_H
# define _LINUX_COMPAT_FS_H

# include <linux/compat/version.h>
# include <linux/compat/compiler.h>
# include <linux/fs.h>


# if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,31)
   typedef void fops_close_ret_t;
#  define FOPS_CLOSE_VALUE(rc)
# else
   typedef int  fops_close_ret_t;
#  define FOPS_CLOSE_VALUE(rc) (rc)
# endif


/* + unstable */

# if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,23)
#  define FOPS_SEEK_PROTOTYPE(name,_inode,_file,_offset,_origin) \
	int name (struct inode* _inode, struct file* _file, \
		off_t _offset, int _origin)
# else
#  define FOPS_SEEK_PROTOTYPE(name,_inode,_file,_offset,_origin) \
	loff_t name (struct file* _file, \
		loff_t _offset, int _origin)
# endif


# if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,0)
#  define FOPS_READ_PROTOTYPE(name,_inode,_file,_buf,_len,_offset) \
	int     name (struct inode* _inode, struct file* _file, \
		char __user* _buf, int    _len)
# else
#  define FOPS_READ_PROTOTYPE(name,_inode,_file,_buf,_len,_offset) \
	ssize_t name (                      struct file* _file, \
		char __user* _buf, size_t _len, loff_t* _offset)
# endif


# if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,0)
#  define FOPS_WRITE_PROTOTYPE(name,_inode,_file,_buf,_len,_offset) \
	int     name (struct inode* _inode, struct file* _file, \
		const char __user* _buf, int    _len)
# else
#  define FOPS_WRITE_PROTOTYPE(name,_inode,_file,_buf,_len,_offset) \
	ssize_t name (                      struct file* _file, \
		const char __user* _buf, size_t _len, loff_t* _offset)
# endif



# if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,23) /* 2.0 */

#  define COMPAT_FOPS_INIT( \
	seek,read,write,readdir,       \
	select,poll,                   \
	ioctl,mmap,open,               \
	flush,                         \
	release,fsync,fasync,          \
	check_media_change,revalidate, \
	lock,                          \
	readv,writev,                  \
	sendpage,get_unmapped_area)    \
\
	{\
		seek,read,write,readdir, select, ioctl,mmap,open,  \
		release,fsync,fasync,check_media_change,revalidate \
	}

# elif LINUX_VERSION_CODE < KERNEL_VERSION(2,4,0) /* 2.2 */

#  define COMPAT_FOPS_INIT( \
	seek,read,write,readdir,       \
	select,poll,                   \
	ioctl,mmap,open,               \
	flush,                         \
	release,fsync,fasync,          \
	check_media_change,revalidate, \
	lock,                          \
	readv,writev,                  \
	sendpage,get_unmapped_area)    \
\
	{\
		seek,read,write,readdir, poll, ioctl,mmap,open, \
		flush, release,fsync,fasync,check_media_change,revalidate, \
		lock \
	}

# elif LINUX_VERSION_CODE < KERNEL_VERSION(2,4,4) /* 2.4.0..3 */

#  define COMPAT_FOPS_INIT( \
	seek,read,write,readdir,       \
	select,poll,                   \
	ioctl,mmap,open,               \
	flush,                         \
	release,fsync,fasync,          \
	check_media_change,revalidate, \
	lock,                          \
	readv,writev,                  \
	sendpage,get_unmapped_area)    \
\
	{\
		THIS_MODULE, \
		seek,read,write,readdir, poll, ioctl,mmap,open, \
		flush, release,fsync,fasync, \
		lock, \
		readv,writev \
	}

# else	/* 2.4.4+ */

#  define COMPAT_FOPS_INIT( \
	seek,read,write,readdir,       \
	select,poll,                   \
	ioctl,mmap,open,               \
	flush,                         \
	release,fsync,fasync,          \
	check_media_change,revalidate, \
	lock,                          \
	readv,writev,                  \
	sendpage,get_unmapped_area)    \
\
	{\
		THIS_MODULE, \
		seek,read,write,readdir, poll, ioctl,mmap,open, \
		flush, release,fsync,fasync, \
		lock, \
		readv,writev, \
		sendpage,get_unmapped_area \
	}

# endif



# if LINUX_VERSION_CODE < KERNEL_VERSION(2,2,0)

#  define COMPAT_INODE_OPERATIONS_INIT( \
	default_file_ops,                \
	create, lookup,                  \
	link, unlink, symlink,           \
	mkdir, rmdir, mknod, rename,     \
	readlink, follow_link,           \
	readpage, writepage,             \
	bmap, truncate, permission, smap \
	,updatepage, revalidate          \
	,prepare_write, sync_page)       \
\
	{\
		default_file_ops,                \
		create, lookup,                  \
		link, unlink, symlink,           \
		mkdir, rmdir, mknod, rename,     \
		readlink, follow_link,           \
		readpage, writepage,             \
		bmap, truncate, permission, smap \
	}

# elif LINUX_VERSION_CODE < KERNEL_VERSION(2,2,18)

#  define COMPAT_INODE_OPERATIONS_INIT( \
	default_file_ops,                \
	create, lookup,                  \
	link, unlink, symlink,           \
	mkdir, rmdir, mknod, rename,     \
	readlink, follow_link,           \
	readpage, writepage,             \
	bmap, truncate, permission, smap \
	,updatepage, revalidate          \
	,prepare_write, sync_page)       \
\
	{\
		default_file_ops,                \
		create, lookup,                  \
		link, unlink, symlink,           \
		mkdir, rmdir, mknod, rename,     \
		readlink, follow_link,           \
		readpage, writepage,             \
		bmap, truncate, permission, smap \
		,updatepage, revalidate          \
	}

# else	/* 2.2.18+ and 2.4.x */

#  define COMPAT_INODE_OPERATIONS_INIT( \
	default_file_ops,                \
	create, lookup,                  \
	link, unlink, symlink,           \
	mkdir, rmdir, mknod, rename,     \
	readlink, follow_link,           \
	readpage, writepage,             \
	bmap, truncate, permission, smap \
	,updatepage, revalidate          \
	,prepare_write, sync_page)       \
\
	{\
		default_file_ops,                \
		create, lookup,                  \
		link, unlink, symlink,           \
		mkdir, rmdir, mknod, rename,     \
		readlink, follow_link,           \
		readpage, writepage,             \
		bmap, truncate, permission, smap \
		,updatepage, revalidate          \
		,prepare_write, sync_page        \
	}

# endif

/* - unstable */



# if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,43)
#  define FILE_INODE(file) ((file)->f_inode)
# else
#  define FILE_INODE(file) ((file)->f_dentry->d_inode)
# endif

# define INODE_MINOR(inode) ((unsigned int)MINOR((inode)->i_rdev))
# define INODE_MAJOR(inode) ((unsigned int)MAJOR((inode)->i_rdev))

# define FILE_MINOR(file) (INODE_MINOR(FILE_INODE(file)))
# define FILE_MAJOR(file) (INODE_MAJOR(FILE_INODE(file)))


# if  LINUX_VERSION_CODE < KERNEL_VERSION(2,0,31)
#  define FILE_OWNER_PID(file) ((file)->f_owner)
# else
#  define FILE_OWNER_PID(file) ((file)->f_owner.pid)
# endif


#endif	/* _LINUX_COMPAT_FS_H */

