/*
	<linux/compat/compiler.h>

	compiled from kernel sources by Dmitry Fedorov, fedorov@inp.nsk.su

	$Id: compiler.h,v 1.3 2003/06/16 13:31:07 fedorov Exp $
*/

#ifndef  _LINUX_COMPAT_COMPILER_H
# define _LINUX_COMPAT_COMPILER_H

# include <linux/compat/version.h>


# if LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,10)
#  include <linux/compiler.h>
# endif



# ifndef  __GNUC_PATCHLEVEL__
#  define __GNUC_PATCHLEVEL__ 0
# endif

# ifndef  GCC_VERSION
#  define GCC_VERSION(major, minor, patchlevel)	\
	((major << 16) + (minor << 8) + patchlevel)
# endif

# ifndef  GCC_VERSION_CODE
#  define GCC_VERSION_CODE	\
          GCC_VERSION(__GNUC__, __GNUC_MINOR__, __GNUC_PATCHLEVEL__)
# endif



# if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,10)
#  if  GCC_VERSION_CODE <    GCC_VERSION(2,96,0)
#   define __builtin_expect(x, expected_value) (x)
#  endif
#
#  define   likely(x)	__builtin_expect((x),1)
#  define unlikely(x)	__builtin_expect((x),0)
# endif


# ifndef   __user
#  ifdef   __CHECKER__
#   define __user	__attribute__((noderef, address_space(1)))
#  else
#   define __user
#  endif
# endif

# ifndef   __kernel
#  ifdef   __CHECKER__
#   define __kernel	/* default address space */
#  else
#   define __kernel
#  endif
# endif


# if GCC_VERSION_CODE >= GCC_VERSION(3,1,0)
#  define   inline	__inline__ __attribute__((always_inline))
#  define __inline__	__inline__ __attribute__((always_inline))
#  define __inline	__inline__ __attribute__((always_inline))
# endif


#endif	/* _LINUX_COMPAT_COMPILER_H */

