
# (C) Alexey R. Buzykaev, buzykaev@inp.nsk.su
#     Dmitry A. Fedorov,   fedorov@inp.nsk.su
#
# $Id: rules.make,v 1.159 2003/07/13 12:17:16 fedorov Exp $

DEP_FILES += $(dfmake_rules)


all_cpp_flags = $(strip $(PRE_INC_FLAGS) $(INCFLAGS) $(INC_FLAGS) $(CPP_FLAGS) $(dfconfig_time_CPPFLAGS) $(CPPFLAGS))
all_c_flags   = $(strip $(compile_c_flags)   $(C_FLAGS) $(all_cpp_flags) $(dfconfig_time_CFLAGS)     $(CFLAGS))
all_cxx_flags = $(strip $(compile_c_flags) $(CXX_FLAGS) $(all_cpp_flags) $(dfconfig_time_CXXFLAGS) $(CXXFLAGS))
all_ld_flags  = $(strip $(LD_FLAGS) $(dfconfig_time_LDFLAGS) $(LDFLAGS))


cvsignore = $(strip $(CVSIGNORE_FILES) $(BIN_NAMES) $(BIN_NAME))


#ifneq "$(filter dist distprep,$(MAKECMDGOALS))" ""
#ifeq "$(_release)"  ".release"
ifdef EXTRA_VERSION_DATE
 date_suffix := -$(shell date -u +'%Y.%m.%d')
else
 date_suffix :=
endif


# targets:

none:

all:


clean:
	@echo "> Cleaning up"
	-$(cmdprefix)$(RM) $(CLEAN_FILES) $(BIN_NAMES) $(BIN_NAME) $(top_lib_file) \
		*.d *.ver *.o *.s *.bak core core.* *.core tags

config configclean:

links linksclean:

dist:
distprep:
distclean: clean configclean

config:

configclean: unmark_dont_install

topdirs:
	$(cmdprefix)$(MKDIR) -p -m 755 $(top_dirs)

topdirsclean:
	-$(cmdprefix)$(RM) -r $(top_dirs)


TOP_INC_DIR ?= $(top_inc_dir)

ifneq "$(filter config%,$(MAKECMDGOALS))" ""
  curdir := $(shell pwd)

  ifneq "$(strip $(TOP_INC_FILES))" ""

topincfiles: topincfilesclean
	$(cmdprefix)$(MKDIR) -p -m 0755 $(TOP_INC_DIR)
	$(cmdprefix)for f in $(TOP_INC_FILES); \
		do $(LN_S) $(curdir)/$$f $(TOP_INC_DIR)/$$f; done

topincfilesclean:
	$(cmdprefix)$(RM) $(addprefix $(TOP_INC_DIR)/,$(TOP_INC_FILES))
    ifneq "$(strip $(TOP_INC_DIR))" "$(strip $(top_inc_dir))"
	$(cmdprefix)$(RMDIR_P) $(TOP_INC_DIR)
    endif

config:      topincfiles
configclean: topincfilesclean

  endif	# TOP_INC_FILES != ""
endif	# MAKECMDGOALS == config%


#+ maintainer only

ifneq "$(filter dist distprep,$(MAKECMDGOALS))" ""
include $(dfmake_dir)/dist.rules.make
endif



ifneq  "$(strip $(NEWREL_RELEASE))" ""
  newrel_r = -r $(NEWREL_RELEASE)
endif

ifneq  "$(strip $(NEWREL_MESSAGE))" ""
  newrel_m = -m $(NEWREL_MESSAGE)
endif

# project release files (for relcheck, newrel targets)
RELEASE_FILES ?= .

newrel:
ifneq "$(strip $(_release))" ""
	$(dfmake_dir)/newrel.sh $(newrel_r) $(newrel_m) $(RELEASE_FILES)
else
	@echo "Nothing to release"
endif

relcheck:
ifneq "$(strip $(_release))" ""
	$(dfmake_dir)/checkrel.pl $(RELEASE_FILES)
else
	@echo "Nothing to check"
endif

#- maintainer only


include $(dfmake_dir)/inst.rules.make


.cvsignore: Makefile
ifneq "$(cvsignore)" ""
	$(cmdprefix)echo "> Generating $@"; \
		echo "$(cvsignore)" >$@
endif

.cvsignoreclean:
	-$(cmdprefix)echo "> Cleaning up .cvsignore"; \
		$(RM) .cvsignore

tags:
	$(cmdprefix)echo "> Generating tags"; \
	$(RM) tags;							\
	find `pwd` -name '*.[hHcCsSiI]*' -follow -print |		\
		ctags -f tags -L - --append --excmd=number --sort=yes	\
		--c-types=+psx -I __P					\
		--file-scope=yes --file-tags=yes --format=1 --totals

tagsclean:
	-$(cmdprefix)echo "> Cleaning up tags"; \
		$(RM) tags


binclean binsclean execlean:
	-$(cmdprefix)echo "> Cleaning up executables"; \
		$(RM) $(CLEAN_FILES) $(BIN_NAMES) $(BIN_NAME)

objclean objsclean:
	-$(cmdprefix)echo "> Cleaning up *.o"; \
		$(RM) *.o

libclean libsclean:
ifneq "$(lib_file)" ""
	-$(cmdprefix)echo "> Cleaning up library $(LIB_NAME)"; \
		$(RM) $(top_lib_file)
endif


obj objs: $(OBJS)

lib libs:


ifeq "$(BUILD_TYPE)" "LIB"

all: lib

lib libs: $(top_lib_file)

$(top_lib_file): $(OBJS) Makefile $(_libname) $(DEP_FILES)
	$(cmdprefix)echo "> Making library $@"; \
		$(AR) rsu $@ $(OBJS)

endif	# BUILD_TYPE == LIB


ifdef LIBS
$(libs_file_keys):
endif


#%: %.o $(libs_file_keys) Makefile $(DEP_FILES)
#	$(cmdprefix)echo "> Linking    $@"; \
#		$(CC) -o $@ $< $(all_ld_flags)


ifeq "$(filter SINGLE_SRC_BINS,$(BUILD_TYPE))" "SINGLE_SRC_BINS"

all:	$(BIN_NAMES)

RCOPY_FILES += $(BIN_NAMES)

$(patsubst %.c.o,%,$(filter %.c.o,$(OBJS))): %: %.c.o $(libs_file_keys) Makefile $(DEP_FILES)
	$(cmdprefix)echo "> Linking    $@"; \
		$(CC) -o $@ $< $(all_ld_flags)

$(patsubst %.cc.o,%,$(filter %.cc.o,$(OBJS))): %: %.cc.o $(libs_file_keys) Makefile $(DEP_FILES)
	$(cmdprefix)echo "> Linking    $@"; \
		$(CXX) -o $@ $< $(all_ld_flags)

endif	# BUILD_TYPE == SINGLE_SRC_BINS


ifeq "$(BUILD_TYPE)" "MULTI_SRC_BIN"

 ifneq "$(filter %.cc.o,$(OBJS))" ""
  _ld_ = $(CXX)
 else
  _ld_ = $(CC)
 endif

all:	$(BIN_NAME)

RCOPY_FILES += $(BIN_NAME)

$(BIN_NAME): $(OBJS) $(libs_file_keys) Makefile $(DEP_FILES)
	$(cmdprefix)echo "> Linking    $@"; \
		$(_ld_) -o $@ $(OBJS) $(all_ld_flags)

endif	# BUILD_TYPE == MULTI_SRC_BIN



ifeq "$(filter LKMOD,$(BUILD_TYPE))" "LKMOD"

all: $(OBJS)

 ifneq "$(lkmod_file)" ""
  lkmodld_flags  = -Ur --sort-common --warn-common #--warn-section-align
  lkmodld_flags += $(LDFLAGS)

all:	lkmod

lkmod: $(lkmod_file)

$(lkmod_file): $(OBJS) Makefile $(DEP_FILES)
	$(cmdprefix)echo "> Linking    $@"; \
	$(LD) $(lkmodld_flags) -o $@ \
		$(filter %begin.c.o,$(OBJS)) \
		$(filter-out %begin.c.o %end.c.o,$(OBJS)) \
		$(filter   %end.c.o,$(OBJS))

RCOPY_FILES += $(lkmod_file)

 endif	# neq "$(lkmod_file)" ""


lk-patch-config:
	$(cmdprefix)$(dfmake_dir)/patch-lk-headers.sh \
		$(lk_inc_dir) $(lkversion) \
		&& $(LN_S) asm-$(target_arch) asm

lk-patch-configclean:
	$(cmdprefix)$(RM) -r linux asm net drivers-scsi; \
	for d in asm-*; do if test -d $$d; then $(RM) -r $$d; fi; done


 ifdef lk_config_smp
  ifdef lk_config_2gb
   genksyms_smp_prefix := -p smp2gig_
  else
   genksyms_smp_prefix := -p smp_
  endif
 else
  ifdef lk_config_2gb
   genksyms_smp_prefix := -p 2gig_
  else
   genksyms_smp_prefix :=
  endif
 endif


# 2.1.18 == 131346
%.ver: %.c Makefile $(DEP_FILES)
	$(cmdprefix)echo "> Generating $@"; \
	$(CPP) $< $(all_cpp_flags) -D__GENKSYMS__ | \
	if test $$[$$[$(lkversion_major)<<16]+$$[$(lkversion_minor)<<8]+$(lkversion_patchlevel)] -lt 131346; then \
		$(GENKSYMS) $(genksyms_smp_prefix) -k $(lkversion_base) . && $(MV) $(notdir $@) $(notdir $@).ver && $(MV) $(notdir $@).ver $@; \
	else \
		$(GENKSYMS) $(genksyms_smp_prefix) -k $(lkversion_base) >$@; \
	fi

endif	# BUILD_TYPE == LKMOD



$(top_lib_dir)/%.o: %.c Makefile $(DEP_FILES)
	$(cmdprefix)echo "> Compiling  $< to $@"; \
		$(CC) -c $< -o $@ $(all_c_flags)


%.c.o:	%.c Makefile $(DEP_FILES)
	$(cmdprefix)echo "> Compiling  $<"; \
		$(CC) -c $< -o $@ $(all_c_flags)

%.cc.o:	%.cc Makefile $(DEP_FILES)
	$(cmdprefix)echo "> Compiling  $<"; \
		$(CXX) -c $< -o $@ $(all_cxx_flags)

%.c.s: %.c Makefile $(DEP_FILES)
	$(cmdprefix)echo "> Compiling  $< to $@"; \
		$(CC)  -S $< -o $@ $(all_c_flags)

%.cc.s: %.cc Makefile $(DEP_FILES)
	$(cmdprefix)echo "> Compiling  $< to $@"; \
		$(CXX) -S $< -o $@ $(all_cxx_flags)


_tt := 55	# to prevent make bug


ifeq "$(_release)"  ".release"
  CVSIGNORE_FILES += .release.h
      CLEAN_FILES += .release.h

  all lib dep: .release.h

  ifeq "$(BUILD_TYPE)" "MULTI_SRC_BIN"
    $(BIN_NAME): .release.h
  endif

  ifeq "$(BUILD_TYPE)" "SINGLE_SRC_BINS"
    $(BIN_NAMES): .release.h
  endif

.release.h: .release Makefile $(DEP_FILES)
	$(cmdprefix)echo "> Generating $@"; \
		$(dfmake_dir)/mkrelh.sh $(date_suffix)

  DEP_FILES      += .release.h
endif	# .release


$(SRCS):;

Makefile:;

$(dfmake_dir)/*.make:;

%.make:;


rcopy:	      $(RCOPY_FILES)
ifeq "$(strip $(RCOPY_FILES))" ""
	@echo "No files to rcopy"
else
	rsync -avcz -e ssh $(RCOPY_FILES) $(RCOPY_DIR)
endif


#+ dependencies generation

dep_gen_cmd_tail = -M $(all_cpp_flags) $< > $@.tmp.d \
	&& sed '\''s!$(subst .,\.,$*.o) *:!$(patsubst %.d,%.o,$@) $@ $(patsubst %.d,%.s,$@):!g'\'' \
	   < $@.tmp.d > $@.tmp2.d \
	&& $(MV) $@.tmp2.d $@ && $(RM) $@.tmp.d; } \
	|| $(RM) $@ $@.tmp.d $@.tmp.d

  c_deps_gen_cmd = $(SHELL) -ec '{ $(CC)  -D__GENDEPS__ $(dep_gen_cmd_tail)'
cxx_deps_gen_cmd = $(SHELL) -ec '{ $(CXX) -D__GENDEPS__ $(dep_gen_cmd_tail)'


%.c.d: %.c Makefile $(DEP_FILES)
	$(cmdprefix)echo "> Generating dependencies for $<"; \
		$(c_deps_gen_cmd)

%.cc.d: %.cc Makefile $(DEP_FILES)
	$(cmdprefix)echo "> Generating dependencies for $<"; \
		$(cxx_deps_gen_cmd)


depclean depsclean:
	-$(cmdprefix)echo "> Cleaning up dependencies"; \
		$(RM) *.d

deps = $(addsuffix .d,$(SRCS))

deps dep: $(deps)

#- dependencies generation


# include deps

ifeq "$(deps)" ""
  DONT_INCLUDE_DEPS = defined
endif

ifneq "$(filter %clean %_uninstall doc_% include_% .cvsignore config tags dist% none newrel relcheck unmark_% mark_%,$(MAKECMDGOALS))" ""
  DONT_INCLUDE_DEPS = defined
endif

ifndef DONT_INCLUDE_DEPS
  -include $(deps)
endif

