#!/bin/bash
#
# $Id: patch-lk-headers.sh,v 1.2 2002/07/16 06:48:10 fedorov Exp $
#
# "dir%file.h+what+N.N.N-[N].patch"
# avoid release range intersections!

echo

if test "$#" -ne 2 ; then
   echo "Usage: $0 LK_INC_DIR KERNEL_RELEASE" 1>&2
   echo 1>&2
   exit 1
fi

    LK_INC_DIR="$1"
KERNEL_RELEASE="$2"


scriptdir=`dirname "$0"`

. "$scriptdir/lk-patch-functions.sh"


function copy_header()
{
  f=copy_header
  if test "$#" -ne 2 ; then
     echo "Usage: $f lk-inc-dir dir/file" 1>&2
     exit 1
  fi

  local lkincdir="$1"
  local dirfile="$2"

  if test  -e "$lkincdir/$dirfile"; then

     local dir="`dirname "$dirfile"`" || exit $?
     mkdir -p "$dir"                  || exit $?
     if test ! -e "$dirfile"; then
	cp -v "$lkincdir/$dirfile" "$dirfile" || exit $?
     fi
  fi
}


function on_match()
{
  if test "$#" -ne 2 ; then
     echo "Usage: on_match lk-inc-dir patch-file" 1>&2
     exit 1
  fi

  local dirfile="`echo "$2" | cut -s -d+ -f1 -`"
        dirfile="`echo "$dirfile" | tr % /`"

  copy_header "$1" "$dirfile" && patch -p0 <"$2" || exit $?
}


patchfile_match_loop . "$LK_INC_DIR" `"$scriptdir/lkversplit" "$KERNEL_RELEASE"`

