#!/bin/sh
#
# commit new '.release' file with optional release argument
# and tag project with generated tag name.
#
# (C) 1999 Dmitry A. Fedorov, fedorov@inp.nsk.su
#
# $Id: newrel.sh,v 1.15 2003/07/13 12:17:15 fedorov Exp $

fullname="$0"
name=newrel

. "`dirname "$0"`"/cvs-rev-tag-functions.sh

usage="
Usage: $name [-m log-message] [-r revision-number] [-h] files ...

-m\tspecify log message for new project release
-r\tspecify CVS revision number for project's '.release' file
-h\tHelp: print this text
\n"


if [ "$#" -lt 1 ] ;
then
    echo -ne "$usage" 1>&2
    exit 1
fi


# Scan for options
while getopts m:r:vh option; do
    case "$option" in
	m)
	    release_log_message="-m \"$OPTARG\""
	    ;;
	r)
	    release_revision="-r$OPTARG"
	    ;;
	h | \?)
	    echo -ne "$usage" 1>&2
	    exit 1
	    ;;
    esac
done

files="$@"

eval cvs commit -f "$release_revision" "${release_log_message}" .release \
     && tagname=`gentagname .release`; \
	if test "$tagname" = "v"; then exit 2; fi \
&& cvs tag "$tagname" $files \
&& cvs update -A .release

