/*
	splits Linux kernel version from arg to components

	$Id: lkversplit.c,v 1.1 2001/12/11 16:23:41 fedorov Exp $
*/

#include <stdio.h>
#include <stdlib.h>

#ifndef  EXIT_SUCCESS
# define EXIT_SUCCESS          0
#endif

#ifndef  EXIT_FAILURE
# define EXIT_FAILURE          1
#endif


int main (int ac, char* av[])
{
    int version, patchlevel, sublevel;
    char extraversion[ 256 ];
    int rc;

    if (ac!=2)
    {
	fprintf(stderr, "\nUsage: %s `uname -r`\n\n", av[0]);
	return EXIT_FAILURE;
    }


    rc = sscanf(av[1], "%d.%d.%d%s",
		&version, &patchlevel, &sublevel, extraversion);
    if (rc<3)
	return EXIT_FAILURE;

    printf("%d %d %d", version, patchlevel, sublevel);
    if (rc==4)
	printf(" %s", extraversion);
    printf("\n");

    return EXIT_SUCCESS;
}

