/*
	prints Linux kernel version components

	$Id: lkversion.c,v 1.1 2001/12/11 17:11:30 fedorov Exp $
*/

#include <stdio.h>
#include <stdlib.h>

#ifndef DONT_INCLUDE_LINUX_VERSION
# include <linux/version.h>
#endif

#ifndef  EXIT_SUCCESS
# define EXIT_SUCCESS          0
#endif

#ifndef  EXIT_FAILURE
# define EXIT_FAILURE          1
#endif


int main (int ac, char* av[])
{
    static char linux_kernel_release[] = UTS_RELEASE;

    int version, patchlevel, sublevel;
    char extraversion[ sizeof(linux_kernel_release) ];

    int rc = sscanf(linux_kernel_release, "%d.%d.%d%s",
		    &version, &patchlevel, &sublevel, extraversion);
    if (rc<3)
	return EXIT_FAILURE;

    printf("%d %d %d", version, patchlevel, sublevel);
    if (rc==4)
	printf(" %s", extraversion);
    printf("\n");

    return EXIT_SUCCESS;
}

