#!/bin/bash
#
# $Id: lk-patch-functions.sh,v 1.3 2002/07/16 06:48:10 fedorov Exp $
#
# "dir%file.h+what+N.N.N-[N].patch"
# avoid release range intersections!


function abs_dir()
{
  if test "$#" -ne 1 ; then
     echo 'Usage: abs_dir dir' 1>&2
     exit 1
  fi

  #(cd "$1" && pwd) || exit $?	# simpler but slower

  pushd "$1" 1>/dev/null || exit $?
  pwd                    || exit $?
  popd       1>/dev/null
}


# $1 - field number
function cutver()
{
  if test "$#" -ne 1 ; then
     echo 'Usage: cutver field-number' 1>&2
     exit 1
  fi

  cut -s -d. -f$1 - || exit $?
}


function split_patchfile_version()
{
  if test "$#" -ne 1 ; then
     echo "Usage: split_patchfile_version dir%file.h+what+N.N.N-[N].patch" 1>&2
     exit 1
  fi

  local f=`basename "$1"`

  local revpatch="`echo "$f" | cut -s -d+ -f3 -`"

  local v1="`echo "$revpatch" | cutver 1`"	# KERNEL_VERSION
  local v2="`echo "$revpatch" | cutver 2`"	# KERNEL_PATCHLEVEL
  local v3="`echo "$revpatch" | cutver 3`"	# KERNEL_SUBLEVEL

  local v3b="`echo "$v3" | cut -s -d- -f1`"	# range begin
  local v3e="`echo "$v3" | cut -s -d- -f2`"	# range end
  if test -z "$v3e"; then v3e="255"; fi

  echo "$v1 $v2 $v3b $v3e"
  return 0
}


function match_release_range()
{
  if test "$#" -ne 8 -o "$4" != "--"; then
     echo "Usage: match_release_range lkv1 lkv2 lkv3 -- v1 v2 v3b v3e" 1>&2
     exit 1
  fi

  test \
	"$1" -eq "$5" -a \
	"$2" -eq "$6" -a \
	"$3" -ge "$7" -a \
	"$3" -le "$8"
}


# "dir%file.h+what+N.N.N-[N].patch"
function patchfile_match_loop()
{
  if test "$#" -ne 5 -a "$#" -ne 6; then
     echo "Usage: patchfile_match_loop patch-dir lk-inc-dir lkv1 lkv2 lkv3 [lkvextra]" 1>&2
     exit 1
  fi

  for f in "$1"/*.h\+*\+"$3"."$4".*-*.patch
  do
    if test ! -e "$f"; then continue; fi

    if match_release_range "$3" "$4" "$5" -- `split_patchfile_version "$f"`; then
       echo "`basename "$f"` is matched to $3.$4.$5"

       on_match "$2" "$f"
       echo
    fi

  done
}

