#
# (C) 1999 Dmitry A. Fedorov, fedorov@inp.nsk.su
#
# $Id: inst.rules.make,v 1.29 2003/07/14 09:44:08 fedorov Exp $
#
# inst targets for project's Makefile

ifndef	dfmakefiles_inst_rules_make
	dfmakefiles_inst_rules_make = included
else
$(error	multiple inclusion)
endif

DEP_FILES += $(dfmake_dir)/inst.rules.make



#++ empty install rules

_base_ := doc conf include lib bin lkmod
_base_install_   := $(addsuffix   _install, $(_base_))
_base_uninstall_ := $(addsuffix _uninstall, $(_base_))

.PHONY: $(_base_install_) $(_base_uninstall_)
        $(_base_install_) $(_base_uninstall_):

.PHONY: prefix_dir_uninstall exec_prefix_dir_uninstall lkmod_prefix_dir_uninstall
        prefix_dir_uninstall exec_prefix_dir_uninstall lkmod_prefix_dir_uninstall:

   .PHONY: install uninstall
  install: $(_base_install_)
uninstall: $(_base_uninstall_)	 exec_prefix_dir_uninstall \
				lkmod_prefix_dir_uninstall \
				      prefix_dir_uninstall


_base_dir_      := $(addsuffix _dir,   $(_base_))
_base_files_    := $(addsuffix _files, $(_base_))
_base_dirfiles_ := $(_base_dir_) $(_base_files_)
_base_dirfiles_install_   := $(addsuffix   _install, $(_base_dirfiles_))
_base_dirfiles_uninstall_ := $(addsuffix _uninstall, $(_base_dirfiles_))

.PHONY:	$(_base_dirfiles_install_) $(_base_dirfiles_uninstall_)
        $(_base_dirfiles_install_) $(_base_dirfiles_uninstall_):


_in = $(1)_install:   $(addprefix $(1),_dir_install _files_install)
_un = $(1)_uninstall: $(addprefix $(1),_files_uninstall _dir_uninstall)

$(call _in,doc)
$(call _un,doc)

$(call _in,conf)
$(call _un,conf)

$(call _in,include)
$(call _un,include)

$(call _in,lib)
$(call _un,lib)

$(call _in,bin)
$(call _un,bin)

$(call _in,lkmod)
$(call _un,lkmod)


_devs_ := dev devs
.PHONY: $(_devs_)
        $(_devs_): devs_install

_devs_inst_   := $(addsuffix   _install,$(_devs_))
_devs_uninst_ := $(addsuffix _uninstall,$(_devs_))

.PHONY: $(_devs_inst_) $(_devs_uninst_)
        $(_devs_inst_) $(_devs_uninst_):

dev devs: devs_install

#-- empty install rules


.PHONY:	mark_dont_install      unmark_dont_install
.PHONY:	mark_list_dont_install unmark_list_dont_install

mark_dont_install:
	$(cmdprefix)touch .dont-install

unmark_dont_install:
	$(cmdprefix)$(RM) .dont-install

_mark_inst_cmd_ = $(cmdprefix) cd $(TOP_DIR) && abstopdir=`pwd` &&  \
	for i in $(MARK_DONT_INSTALL_DIRS); do \
		cd $$abstopdir/$$i && \
		dirlist=`find . -name Makefile -printf '%h\n'` && \
		for d in $$dirlist; \
			do $(MAKE) -C $$d __mark_target__; \
		done \
	done

mark_list_dont_install:
ifneq "$(strip $(MARK_DONT_INSTALL_DIRS))" ""
	$(subst __mark_target__,mark_dont_install,$(_mark_inst_cmd_))
endif

unmark_list_dont_install:
ifneq "$(strip $(MARK_DONT_INSTALL_DIRS))" ""
	$(subst __mark_target__,unmark_dont_install,$(_mark_inst_cmd_))
endif


ifndef DONT_INSTALL
 ifeq "$(findstring install,$(MAKECMDGOALS))" "install"
  _dont_install := $(wildcard .dont-install)
  ifneq "$(strip $(_dont_install))" ".dont-install"

   ifndef INSTALL_OWNER
          INSTALL_OWNER := $(shell id -u)
   endif

   ifndef INSTALL_GROUP
          INSTALL_GROUP := $(shell id -g)
   endif

   install_id_flags = -o$(INSTALL_OWNER) -g$(INSTALL_GROUP)


   INST_BIN_DIR     ?=     $(BINDIR)
   INST_CONF_DIR    ?= $(SYSCONFDIR)
   INST_LIB_DIR     ?=     $(LIBDIR)
   INST_INCLUDE_DIR ?= $(INCLUDEDIR)
   INST_DOC_DIR     ?=     $(DOCDIR)

   ifeq "$(BUILD_TYPE)" "SINGLE_SRC_BINS"
     INST_BIN_FILES ?= $(BIN_NAMES)
   endif

   ifeq "$(BUILD_TYPE)" "MULTI_SRC_BIN"
     INST_BIN_FILES ?= $(BIN_NAME)
   endif

   ifeq "$(BUILD_TYPE)" "LKMOD"
     INST_LKMOD_FILES ?= $(lkmod_file)

     INST_LKMOD_DIR_BASE ?= $(LKMOD_PREFIX)/lib/modules/$(lkversion)
     INST_LKMOD_DIR_SUFFIX ?= misc

     ifndef INST_LKMOD_DIR
      ifneq "$(strip $(INST_LKMOD_DIR_SUFFIX))" ""
        INST_LKMOD_DIR = $(INST_LKMOD_DIR_BASE)/$(INST_LKMOD_DIR_SUFFIX)
      endif
     endif
   endif


   #++ bin_install
   ifneq "$(INST_BIN_FILES)" ""

bin_dir_install: $(INST_BIN_DIR)

$(INST_BIN_DIR):
	$(cmdprefix)echo "> Creating directory $@"; \
		$(MKDIR) -p $(install_id_flags) -m 755 $@

bin_dir_uninstall: bin_files_uninstall
	-$(cmdprefix)$(RMDIR_P) $(INST_BIN_DIR)

bin_files_install: bin_dir_install $(INST_BIN_FILES)
	$(cmdprefix)echo "> Install binary files $(INST_BIN_FILES) to $(INST_BIN_DIR)"; \
		$(INSTALL) $(install_id_flags) -m 555 $(INST_BIN_FILES) $(INST_BIN_DIR)

bin_files_uninstall:
	-$(cmdprefix)echo "> Removing binary files $(INST_BIN_FILES) from $(INST_BIN_DIR)"; \
		cd $(INST_BIN_DIR) && $(RM) $(INST_BIN_FILES)

   endif
   #-- bin_install


   #++ conf_install
   ifneq "$(INST_CONF_FILES)" ""

conf_dir_install: $(INST_CONF_DIR)

$(INST_CONF_DIR):
	$(cmdprefix)echo "> Creating directory $@"; \
		$(MKDIR) -p $(install_id_flags) -m 755 $@

conf_dir_uninstall: conf_files_uninstall
	-$(cmdprefix)$(RMDIR_P) $(INST_CONF_DIR)

conf_files_install: conf_dir_install $(INST_CONF_FILES)
	$(cmdprefix)echo "> Install configuration files $(INST_CONF_FILES) to $(INST_CONF_DIR)"; \
		$(INSTALL) $(install_id_flags) -m 644 $(INST_CONF_FILES) $(INST_CONF_DIR)

conf_files_uninstall:
	-$(cmdprefix)echo "> Removing configuration files $(INST_CONF_FILES) from $(INST_CONF_DIR)"; \
		cd $(INST_CONF_DIR) && $(RM) $(INST_CONF_FILES)

   endif
   #-- conf_install


   #++ lib_install
   ifdef LIB_NAME

lib_dir_install: $(INST_LIB_DIR)

$(INST_LIB_DIR):
	$(cmdprefix)echo "> Creating directory $@"; \
		$(MKDIR) -p $(install_id_flags) -m 755 $@

lib_dir_uninstall: lib_files_uninstall
	-$(cmdprefix)$(RMDIR_P) $(INST_LIB_DIR)

lib_files_install: lib_dir_install lib
	$(cmdprefix)echo "> Install $(lib_file) to $(INST_LIB_DIR)"; \
		$(INSTALL) $(install_id_flags) -m 444 $(top_lib_file) $(INST_LIB_DIR)

lib_files_uninstall:
	-$(cmdprefix)echo "> Removing $(INST_LIB_DIR)/$(lib_file)"; \
		$(RM) $(INST_LIB_DIR)/$(lib_file)

   endif	# LIB_NAME
   #-- lib_install


   #++ include_install
   ifneq "$(INST_INCLUDE_FILES)" ""

include_dir_install: $(INST_INCLUDE_DIR)

$(INST_INCLUDE_DIR):
	$(cmdprefix)echo "> Creating directory $@"; \
		$(MKDIR) -p $(install_id_flags) -m 755 $@

include_dir_uninstall: include_files_uninstall
	-$(cmdprefix)$(RMDIR_P) $(INST_INCLUDE_DIR)

include_files_install: include_dir_install
	$(cmdprefix)echo "> Install include files $(INST_INCLUDE_FILES) to $(INST_INCLUDE_DIR)"; \
		$(INSTALL) $(install_id_flags) -m 444 $(INST_INCLUDE_FILES) $(INST_INCLUDE_DIR)

include_files_uninstall:
	-$(cmdprefix)echo "> Removing include files $(INST_INCLUDE_FILES) from $(INST_INCLUDE_DIR)"; \
		cd $(INST_INCLUDE_DIR) && $(RM) $(INST_INCLUDE_FILES)

   endif	# $(INST_INCLUDE_FILES)
   #-- include_install


   #++ lkmod_install
   ifneq "$(strip $(INST_LKMOD_FILES))" ""

lkmod_dir_install: $(INST_LKMOD_DIR)

$(INST_LKMOD_DIR):
	$(cmdprefix)echo "> Creating directory $@"; \
		$(MKDIR) -p $(install_id_flags) -m 755 $@

lkmod_dir_uninstall: lkmod_files_uninstall
	-$(cmdprefix)$(RMDIR_P) $(INST_LKMOD_DIR)

lkmod_files_install: lkmod lkmod_dir_install
	$(cmdprefix)echo "> Install kernel module files $(INST_LKMOD_FILES) to $(INST_LKMOD_DIR)"; \
		$(INSTALL) $(install_id_flags) -m 444 $(INST_LKMOD_FILES) $(INST_LKMOD_DIR)

lkmod_files_uninstall:
	-$(cmdprefix)echo "> Removing kernel module files $(INST_LKMOD_FILES) from $(INST_LKMOD_DIR)"; \
		$(RM) $(addprefix $(INST_LKMOD_DIR)/,$(INST_LKMOD_FILES))

lkmod_prefix_dir_uninstall:
	-$(cmdprefix)$(RMDIR_P) $(LKMOD_PREFIX)

   endif	# $(INST_LKMOD_FILES)
   #-- lkmod_install


   #++ doc_install
   ifneq "$(INST_DOC_FILES)" ""

doc_dir_install: $(INST_DOC_DIR)

$(INST_DOC_DIR):
	$(cmdprefix)echo "> Creating directory $@"; \
		$(MKDIR) -p $(install_id_flags) -m 755 $@

doc_dir_uninstall: doc_files_uninstall
	-$(cmdprefix)$(RMDIR_P) $(INST_DOC_DIR)


doc_files_install: doc_dir_install
	$(cmdprefix)echo "> Install doc files $(INST_DOC_FILES) to $(INST_DOC_DIR)"; \
		$(INSTALL) $(install_id_flags) -m 444 $(INST_DOC_FILES) $(INST_DOC_DIR)

doc_files_uninstall:
	-$(cmdprefix)echo "> Removing doc files $(INST_DOC_FILES) from $(INST_DOC_DIR)"; \
		cd $(INST_DOC_DIR) && $(RM) $(INST_DOC_FILES)

   endif	# $(INST_DOC_FILES)
   #-- doc_install


exec_prefix_dir_uninstall:
	-$(cmdprefix)$(RMDIR_P) $(EXEC_PREFIX)
     prefix_dir_uninstall:
	-$(cmdprefix)$(RMDIR_P)      $(PREFIX)

  endif	#- .dont-install
 endif	#- install
endif	# ndef DONT_INSTALL

