#
# (C) 1999 Dmitry A. Fedorov, fedorov@inp.nsk.su
#
# $Id: dist.rules.make,v 1.13 2003/07/07 18:52:18 fedorov Exp $
#
# dist targets for project's Makefile

ifndef	dfmakefiles_dist_rules_make
	dfmakefiles_dist_rules_make = included
else
$(error	multiple inclusion)
endif

DEP_FILES += $(dfmake_dir)/dist.rules.make


ifneq "$(filter dist distprep,$(MAKECMDGOALS))" ""
    # using 'pwd' may cause that shell's built-in with the same name
    # used with incorrect result in some circumstances;
    # so use /bin/pwd and don't use absolute TOP_DIR directly
    topdir		:= $(shell cd $(TOP_DIR) && /bin/pwd)
    curdir		:= $(shell /bin/pwd)
    this_package	:= $(subst $(topdir)/,,$(curdir))

    ifneq "$(PACKAGE_NAME)" ""
      tgzbasename := $(PACKAGE_NAME)
    else
      tgzbasename := $(subst /,-,$(this_package))
    endif


    _release := $(shell . $(dfmake_dir)/cvs-rev-tag-functions.sh; cutrev .release)
    ifneq "$(_release)" ""
	release := -$(_release)
    endif

    tgzrelname := $(tgzbasename)$(release)$(date_suffix)

    topconstfiles := Makefile INSTALL.GENERIC

    ifneq "$(filter $(topconstfiles),$(DIST_FILES_TO_TOP_DIR))" ""
	$(error $(topconstfiles) not allowed to be copied to TOP_DIR)
    endif

    packages := $(topconstfiles) $(notdir $(DIST_FILES_TO_TOP_DIR))
    packages += $(this_package) $(REQUIRED_PACKAGES)
    files    := $(addprefix $(tgzrelname)/,$(packages))

    exclude_tar_flags += \
	$(foreach _i_,$(DIST_EXCLUDE_FILES),"--exclude=$(_i_)")

dist:	$(EXTRA_DIST_DEPS) distprep
	$(trace_target)
	@echo "> Making complete $(tgzrelname).tar.gz"
	$(cmdprefix)$(MKDIR) -p $(top_exp_dir) && \
	cd $(topdir)/.. && \
	$(RM) $(tgzrelname) && \
	$(LN_S) $(topdir) $(tgzrelname) && \
	export GZIP=--best && tar -czv \
	--exclude-from=$(dfmake_dir)/exclude-file-list-export \
	$(exclude_tar_flags) --totals \
	-f $(topdir)/export/$(tgzrelname).tar.gz \
	$(files); \
	$(RM) $(tgzrelname); \
	cd $(topdir) && $(RM) $(notdir $(DIST_FILES_TO_TOP_DIR))

ifneq "$(DIST_FILES_TO_TOP_DIR)" ""
distprep:
	$(trace_target)
	cd $(TOP_DIR) && for i in $(DIST_FILES_TO_TOP_DIR); do \
	$(LN_S) -f $(this_package)/$$i; done
endif

endif	# dist

