#
# (C) Alexey R. Buzykaev, buzykaev@inp.nsk.su
#     Dmitry A. Fedorov,   fedorov@inp.nsk.su
#
# $Id: defs.make,v 1.121 2003/07/07 12:35:07 fedorov Exp $
#
# Common definitions for project's Makefile

ifndef	dfmakefiles_defs_make
	dfmakefiles_defs_make = included
else
$(error	multiple inclusion)
endif

ifndef	  TOP_DIR
  $(error TOP_DIR undefined)
endif

dfmake_dir   = $(TOP_DIR)/dfmakefiles
dfmake_defs  = $(dfmake_dir)/defs.make
dfmake_rules = $(dfmake_dir)/rules.make

DEP_FILES += $(dfmake_defs)


#trace_target = @echo target: $@



# Delete suffixes by default
.SUFFIXES:

# Delete rules by default
.DEFAULT:

.DEFAULT:
	$(error no rules for target $@)


include $(dfmake_dir)/phony.rules.make


all:

none:

ifneq "$(filter %clean dist% .cvsignore newrel relcheck,$(MAKECMDGOALS))" ""
  DONT_INCLUDE_CONFIG_MAKE = defined
endif

ifndef DONT_INCLUDE_CONFIG_MAKE
  DEP_FILES += $(dfmake_dir)/.config.make

  include $(dfmake_dir)/.config.make

  $(dfmake_dir)/.config.make:
	$(error Was not configured by 'make config' command)
endif

include $(dfmake_dir)/progdefs.make
include $(dfmake_dir)/dirdefs.make

vpath
vpath lib%.a  $(top_lib_dir)
vpath lib%.so $(top_lib_dir)
#vpath %.h $(top_inc_dir)/include


#+ make verbose=0|1|2

ifeq "$(strip $(verbose))" ""
 VERBOSE=0
else
 ifeq "$(strip $(verbose))" "0"
  VERBOSE=0
 else
  ifeq "$(strip $(verbose))" "1"
   VERBOSE=1
  else
   ifeq "$(strip $(verbose))" "2"
    VERBOSE=2
   endif
  endif
 endif
endif

ifeq "$(VERBOSE)" "0"
     cmdprefix = @
#    cmdsuffix = >&2
else
 ifeq "$(VERBOSE)" "1"
     cmdprefix =
     cmdsuffix =
 else
  ifeq "$(VERBOSE)" "2"
     cmdprefix =
     cmdsuffix =
     CPP_FLAGS += -v
   C_CXX_FLAGS += -v
  endif
 endif
endif

#- make verbose=0|1|2



  COMPILEOPTION ?= OPTIMIZE
# COMPILEOPTION ?= FAST
# COMPILEOPTION ?= DEBUG


ifndef STRICT
  ifdef dfconfig_time_STRICT
    STRICT = defined
  endif
endif

 cc_is_gnu ?= $(dfconfig_time_cc_is_gnu)
cxx_is_gnu ?= $(dfconfig_time_cxx_is_gnu)

ifndef	OPTIMIZELEVEL
  ifdef dfconfig_time_OPTIMIZELEVEL
    OPTIMIZELEVEL = $(dfconfig_time_OPTIMIZELEVEL)
  else
    OPTIMIZELEVEL = 3		# 0..3
  endif
endif


COMPILEOPTION := $(strip $(COMPILEOPTION))
OPTIMIZELEVEL := $(strip $(OPTIMIZELEVEL))


ifeq "$(COMPILEOPTION)" "DEBUG"
  CPP_FLAGS += -DDEBUG
endif

ifeq "$(COMPILEOPTION)" "FAST"
  compile_c_flags = -O0
else
  ifeq "$(COMPILEOPTION)" "DEBUG"
    compile_c_flags = -g -O0 -fno-inline
  else
    ifeq "$(COMPILEOPTION)" "OPTIMIZE"
      compile_c_flags = -O$(OPTIMIZELEVEL) #-fomit-frame-pointer
    else
      COMPILEOPTION = FAST
    endif
  endif
endif

ifeq "$(COMPILEOPTION)" "OPTIMIZE"
  LD_FLAGS += -s
endif



# BUILD_TYPE:	LIB LKMOD SINGLE_SRC_BINS MULTI_SRC_BIN


_release   := $(wildcard .release)
_libname   := $(wildcard .libname)
_lkmodname := $(wildcard .lkmodname)

ifndef BUILD_TYPE
  ifneq "$(_libname)" ""
    BUILD_TYPE := LIB
  endif
  ifneq "$(_lkmodname)" ""
    BUILD_TYPE := LKMOD
  endif
endif	# ndef BUILD_TYPE


ifndef SRCS
 SRCS := $(wildcard *.c *.cc)
endif

OBJS ?= $(patsubst %,%.o,$(SRCS))

ifeq "$(filter SINGLE_SRC_BINS,$(BUILD_TYPE))" "SINGLE_SRC_BINS"
  BIN_NAMES ?= $(basename $(SRCS))
endif



ifeq "$(BUILD_TYPE)" "LIB"

 ifndef LIB_NAME
  ifneq "$(_libname)" ""
    LIB_NAME := $(shell cat .libname)
  endif
 endif

 LIB_NAME := $(strip $(LIB_NAME))

 ifeq  "$(LIB_NAME)" ""
  $(error LIB_NAME unspecified)
 endif

     lib_file := lib$(LIB_NAME).a
 top_lib_file := $(top_lib_dir)/$(lib_file)

endif	# BUILD_TYPE == LIB



libs_file_keys = $(LIBS:%=-l%)



ifeq "$(filter LKMOD,$(BUILD_TYPE))" "LKMOD"

#lkmod_suffix := .o
#lkmod_suffix := .ko
 lkmod_suffix :=

 lkmod_suffix := $(strip $(lkmod_suffix))

 ifndef LKMOD_NAME
  ifneq "$(_lkmodname)" ""
    LKMOD_NAME := $(shell cat .lkmodname)
  endif
 endif

 LKMOD_NAME := $(strip $(LKMOD_NAME))

 ifneq "$(LKMOD_NAME)" ""
   lkmod_file = $(LKMOD_NAME)$(lkmod_suffix)
 endif

 CVSIGNORE_FILES += $(lkmod_file)
     CLEAN_FILES += $(lkmod_file)

 COMPILEOPTION = OPTIMIZE


lkversion            = $(dfconfig_time_lkversion)
lkversion_base       = $(dfconfig_time_lkversion_base)
lkversion_major      = $(dfconfig_time_lkversion_major)
lkversion_minor      = $(dfconfig_time_lkversion_minor)
lkversion_patchlevel = $(dfconfig_time_lkversion_patchlevel)
lkversion_extra      = $(dfconfig_time_lkversion_extra)


 ifdef STRICT
  PRE_INC_DIRS += $(TOP_DIR)/linux/warning-cleaned-headers
 endif
  PRE_INC_DIRS += $(TOP_DIR)/linux/error-cleaned-headers

  ifdef lk_config_modversions
    CPP_FLAGS += --include=$(TOP_DIR)/linux/df/modversions.h
  endif

 ifneq "$(cc_is_gnu)" ""
  INC_DIRS  += $(gcc_inc_dir)
  CPP_FLAGS += -nostdinc
 endif

endif	# BUILD_TYPE == LKMOD


# out of LKMOD - compromiss with redhat
lk_inc_dir = $(dfconfig_time_lk_inc_dir)

INC_DIRS += $(top_inc_dir) $(TOP_DIR)

INC_DIRS += $(lk_inc_dir)	# out of LKMOD - compromiss with redhat


PRE_INC_FLAGS += $(foreach _i_,$(PRE_INC_DIRS),-I$(_i_))
INCFLAGS  += $(foreach _i_,$(INCDIRS) $(dfconfig_time_INCDIRS),-I$(_i_))
INC_FLAGS += $(foreach _i_,$(INC_DIRS),-I$(_i_))


CPP_FLAGS += -D_GNU_SOURCE


#+ common C and C++ flags
ifdef STRICT
C_CXX_FLAGS += -Wall -W #-Werror
#C_CXX_FLAGS += -Wpointer-arith
C_CXX_FLAGS += -Wcast-qual
C_CXX_FLAGS += -Wcast-align
C_CXX_FLAGS += -Wwrite-strings
C_CXX_FLAGS += -Winline
else
C_CXX_FLAGS += -w	# supress warnings
endif

C_CXX_FLAGS += -Wa,-W	#supress assembler warnings
C_CXX_FLAGS += -fno-inline-functions -fno-unroll-loops -fno-unroll-all-loops
C_CXX_FLAGS += -freg-struct-return -fshort-enums
#C_CXX_FLAGS += -fshared-data	#threads?
#C_CXX_FLAGS += -fstack-check	#check stack boundary for threads
#- common C and C++ flags

#+ C only flags
C_FLAGS += $(GCCFLAG_PIPE) $(C_CXX_FLAGS)
C_FLAGS += $(GCCFLAG_F_NO_KEEP_STATIC_CONSTS)

ifdef STRICT
C_FLAGS += $(GCCFLAG_W_BAD_FUNCTION_CAST)
C_FLAGS += $(GCCFLAG_W_STRICT_PROTOTYPES)
C_FLAGS += $(GCCFLAG_W_ERROR_IMPLICIT_FUNCTION_DECLARATION)
C_FLAGS += $(GCCFLAG_W_DEPRECATED)

C_FLAGS += $(GCCFLAG_W_DISABLED_OPTIMIZATION)
#C_FLAGS += $(GCCFLAG_W_FLOAT_EQUAL)
#C_FLAGS += $(GCCFLAG_W_PACKED)
#C_FLAGS += $(GCCFLAG_W_PADDED)
#C_FLAGS += $(GCCFLAG_W_UNREACHABLE_CODE)
else
C_FLAGS += $(GCCFLAG_W_NO_DEPRECATED)
endif
#- C only flags


#+ C++ only flags
CXX_FLAGS += $(GXXFLAG_PIPE) $(C_CXX_FLAGS)
CXX_FLAGS += -ffor-scope					# default?
CXX_FLAGS += $(GXXFLAG_F_NO_RTTI)
CXX_FLAGS += $(GXXFLAG_F_NO_EXCEPTIONS)				# g++ v2.8+
CXX_FLAGS += -fno-implement-inlines
CXX_FLAGS += -fno-implicit-templates
CXX_FLAGS += $(GXXFLAG_F_NO_IMPLICIT_INLINE_TEMPLATES)		# g++ 2.95+
CXX_FLAGS += $(GXXFLAG_F_VTABLE_THUNKS)	# incompatible with old libg++,
					# default for libstdc++
#CXX_FLAGS += $(GXXFLAG_F_VTABLE_GC)
CXX_FLAGS += $(GXXFLAG_F_NO_ENFORCE_EH_SPECS)
CXX_FLAGS += $(GXXFLAG_F_NO_KEEP_STATIC_CONSTS)
CXX_FLAGS += $(GXXFLAG_W_NO_NON_VIRTUAL_DTOR)
#CXX_FLAGS += -fcheck-new

ifdef STRICT
CXX_FLAGS += -Woverloaded-virtual
CXX_FLAGS += -Wsynth
CXX_FLAGS += $(GXXFLAG_W_BAD_FUNCTION_CAST)
CXX_FLAGS += $(GXXFLAG_W_STRICT_PROTOTYPES)
CXX_FLAGS += $(GXXFLAG_F_STRICT_PROTOTYPE)
CXX_FLAGS += $(GXXFLAG_W_ERROR_IMPLICIT_FUNCTION_DECLARATION)	# g++ 2.91.66+
CXX_FLAGS += $(GXXFLAG_W_DEPRECATED)				# g++ 2.95+
CXX_FLAGS += $(GXXFLAG_W_SIGN_PROMO)				# g++ 2.95+
CXX_FLAGS += -Wctor-dtor-privacy
#CXX_FLAGS += -Wold-style-cast
CXX_FLAGS += -Wreorder
CXX_FLAGS += $(GXXFLAG_W_PMF_CONVERSIONS)
#CXX_FLAGS += $(GXXFLAG_W_EFFCXX)				# g++ 2.8+

CXX_FLAGS += $(GXXFLAG_W_DISABLED_OPTIMIZATION)
#CXX_FLAGS += $(GXXFLAG_W_FLOAT_EQUAL)
#CXX_FLAGS += $(GXXFLAG_W_PACKED)
#CXX_FLAGS += $(GXXFLAG_W_PADDED)
#CXX_FLAGS += $(GXXFLAG_W_UNREACHABLE_CODE)
CXX_FLAGS += $(GXXFLAG_W_ABI)
else
CXX_FLAGS += $(GXXFLAG_W_NO_DEPRECATED)				# g++ 2.95+
CXX_FLAGS += $(GXXFLAG_F_PERMISSIVE)
endif
#- C++ only flags


ifeq "$(filter LKMOD,$(BUILD_TYPE))" "LKMOD"

  CPP_FLAGS += -D__KERNEL__ -DMODULE
C_CXX_FLAGS += -Wno-unused
    C_FLAGS += $(GCCFLAG_F_NO_STRICT_ALIASING)	# gcc 2.91+
  CXX_FLAGS += $(GXXFLAG_F_NO_STRICT_ALIASING)	# gcc 2.91+
    C_FLAGS += $(GCCFLAG_W_NO_SIGN_COMPARE)
  CXX_FLAGS += $(GXXFLAG_W_NO_SIGN_COMPARE)
    C_FLAGS += $(GCCFLAG_W_NO_BAD_FUNCTION_CAST)
  CXX_FLAGS += $(GXXFLAG_W_NO_BAD_FUNCTION_CAST)
  CXX_FLAGS += $(GXXFLAG_F_NO_USE_CXA_ATEXIT)


  ifdef lk_config_m686
    C_CXX_FLAGS += -mpentiumpro
  else
  ifdef lk_config_m586
    C_CXX_FLAGS += -mpentium
  else
  ifdef lk_config_m486
    C_CXX_FLAGS += -m486
  else
  ifdef lk_config_m386
    C_CXX_FLAGS += -m386
  endif
  endif
  endif
  endif

endif	# BUILD_TYPE == LKMOD


startgroup = -Xlinker --start-group
endgroup   = -Xlinker --end-group

 LD_FLAGS += -L$(top_lib_dir) $(startgroup) $(libs_file_keys) $(endgroup)
XLD_FLAGS += -L/usr/X11/lib -L/usr/X11R6/lib -L/usr/X11R5/lib -lX11


man1ext = .1
man2ext = .2
man3ext = .3
man4ext = .4
man5ext = .5
man6ext = .6
man7ext = .7
man8ext = .8
man9ext = .9

