#!/bin/sh
#
# shell functions to deal with project release
#
# (C) 1999 Dmitry A. Fedorov, fedorov@inp.nsk.su
#
# $Id: cvs-rev-tag-functions.sh,v 1.5 2003/06/04 13:39:29 fedorov Exp $


# extract and filter cvs tags list for specified files
function taglist()
{
	cvs status -v "$@" | grep '\(revision: .*\)$'
}

# Cuts out revision number from $Revision: 1.5 $ string of specified file
# (use '-' to use stdin)
function cutrev()
{
	cut -s -d\$ -f2 "$1" | grep 'Revision:' | cut -s -d\  -f2
}

# Cuts out tag prefix from $tag_prefix: prefix $ string of specified file
# (use '-' to use stdin)
function cut_tag_prefix()
{
	cut -s -d\$ -f2 "$1" | grep 'tag_prefix:' | cut -s -d\  -f2
}

# Replace dot in revision number to underscore to form legal CVS tag name
# (pipe)
function rev2tag()
{
	tr . _
}

# generate legal CVS tag name from Revision keyword of specified file
# (use '-' to use stdin)
function gentagname()
{
	tag_prefix=`cut_tag_prefix "$1"`
	if test -z "$tag_prefix"; then tag_prefix=v; fi
	echo "$tag_prefix"`cutrev "$1" | rev2tag`
}

