#!/bin/sh
#
# test compiler features and write .config.make
#
# $Id: config.sh,v 1.103 2003/07/07 12:59:55 fedorov Exp $

TOP_DIR=..

# Be Bourne compatible
if test -n "${ZSH_VERSION+set}" && (emulate sh) >/dev/null 2>&1; then
  emulate sh
  NULLCMD=:
elif test -n "${BASH_VERSION+set}" && (set -o posix) >/dev/null 2>&1; then
  set -o posix
fi


# include functions
. ./config-util.sh
. ./config-print.sh
. ./config-format.sh
. ./config-check.sh


rm -f .config.make .config.log

echo "DEP_FILES += \$(TOP_DIR)/dfmakefiles/.config.make" >>.config.make
log; empty_conf


check_host_target_var_conf host
empty_conf
check_host_target_var_conf target
empty_conf

target_arch=`_normalize_arch "$target_cpu"`
set_var_conf target_arch
log; empty_conf

if  test "$target_os" = "linux-gnu"; then
    logn "`fmt_cc_prefix \"checking whether we have to build Linux kernel sources\"` ... "
    have_linux_kernel_sources="`find .. -type f -name .lkmodname -print`"

    if  test -n "$have_linux_kernel_sources"; then log 'yes'; else log 'no'; fi

    log; empty_conf
fi

check_env_var_conf -truncate -right         PREFIX  /usr/local
check_env_var_conf -truncate -right    EXEC_PREFIX      "$PREFIX"
check_env_var_conf -truncate -right   LKMOD_PREFIX           "''"
check_env_var_conf -truncate -right         BINDIR "$EXEC_PREFIX/bin"
check_env_var_conf -truncate -right        SBINDIR "$EXEC_PREFIX/sbin"
check_env_var_conf -truncate -right     LIBEXECDIR "$EXEC_PREFIX/libexec"
check_env_var_conf -truncate -right        DATADIR      "$PREFIX/share"
check_env_var_conf -truncate -right     SYSCONFDIR      "$PREFIX/etc"
check_env_var_conf -truncate -right SHAREDSTATEDIR      "$PREFIX/com"
check_env_var_conf -truncate -right  LOCALSTATEDIR      "$PREFIX/var"
check_env_var_conf -truncate -right         LIBDIR "$EXEC_PREFIX/lib"
check_env_var_conf -truncate -right     INCLUDEDIR      "$PREFIX/include"
check_env_var_conf -truncate -right        INFODIR      "$PREFIX/info"
check_env_var_conf -truncate -right         DOCDIR      "$PREFIX/doc"
check_env_var_conf -truncate -right         MANDIR      "$PREFIX/man"
check_env_var_conf -truncate -right         DEVDIR             "/dev"

log; empty_conf

if  test -n "$INCDIRS"; then
    INCDIRS="`truncate_slashes \"$INCDIRS\"`"
    export INCDIRS
fi

check_env_var_conf OPTIMIZELEVEL    ""
check_env_var_conf INCDIRS          ""

if  test -n "$have_linux_kernel_sources"; then
    if  test -n "$LKSRCDIR"; then
	LKSRCDIR="`truncate_slashes \"$LKSRCDIR\"`"
	export LKSRCDIR
    fi

    check_env_var_conf LKSRCDIR     ""
    check_env_var_conf LKVERSION    ""
fi

log; empty_conf

check_env_var_conf -right CPPFLAGS  ""
check_env_var_conf -right   CFLAGS  ""
check_env_var_conf -right CXXFLAGS  ""
check_env_var_conf -right  LDFLAGS  ""

log; empty_conf

if  false && test -n "$have_linux_kernel_sources"; then
    logn "`fmt_cc_prefix \"checking whether kgcc compiler exists\"` ... "

    if  test -n "`_which kgcc`"; then
	cc=kgcc
	cxx='kgcc -xc++'
	log 'yes'
    else
	cc=gcc
	cxx=g++
	log 'no'
    fi
fi

logn "`fmt_cc_prefix \"checking whether  gcc compiler exists\"` ... "
if  test -n "`_which gcc`"; then
    cc=gcc
    cxx='g++'
    log 'yes'
else
    cc=
    cxx=
    log 'no'
fi

log; empty_conf

check_env_var_conf CC    "$cc"
check_env_var_conf CPP   "$CC -E"
#check_c_existence	################

logn "`fmt_prefix checking for CC  version` ... "
ccver=`$CC -dumpversion 2>/dev/null || $CC -version 2>&1`
log "`fmt_suffix \"$ccver\"`"

check_cc_is_gnu_conf "$CC" c 'CC'

log

check_env_var_conf CXX   "$cxx"
check_env_var_conf CXXPP "$CXX -E"
#check_cxx_existence	####################

logn "`fmt_prefix checking for CXX version` ... "
cxxver=`$CXX -dumpversion 2>/dev/null || $CXX -version 2>&1`
log "`fmt_suffix \"$cxxver\"`"

check_cc_is_gnu_conf "$CXX" c++ 'CXX'

log

check_env_var_conf AS  as
check_env_var_conf LD  ld

if  test -n "$have_linux_kernel_sources"; then

    if	test -z "$GENKSYMS"; then
	PATH=/usr/local/sbin:/usr/sbin:/sbin:"$PATH"
	_genksyms=`_which genksyms`

	if test -n "$_genksyms"; then
	    _guessed='-guessed'
	else
	    unset _guessed
	fi
    fi

    check_env_var_conf $_guessed GENKSYMS "$_genksyms"

    if  test -z "$GENKSYMS"; then
	die "genksyms not found; check whether modutils installed"
    fi
fi

log; empty_conf

if test -n "$cc_is_gnu"; then
 check_gcc_flag_conf "$CC"  'c'   "-pipe"                   GCCFLAG_PIPE
 check_gcc_flag_conf "$CC"  'c'   "-Os"                     GCCFLAG_OPTIMIZE_FOR_SIZE
 check_gcc_flag_conf "$CC"  'c'   "-fno-strict-aliasing"    GCCFLAG_F_NO_STRICT_ALIASING
 #check_gcc_flag_conf "$CC"  'c'   "-finline-limit=3000"     GCCFLAG_F_INLINE_LIMIT_3000
 check_gcc_flag_conf "$CC"  'c'   "-fno-keep-static-consts" GCCFLAG_F_NO_KEEP_STATIC_CONSTS
 check_gcc_flag_conf "$CC"  'c'   "-Wno-sign-compare"       GCCFLAG_W_NO_SIGN_COMPARE

 log; empty_conf
fi	# cc_is_gnu

if test -n "$cxx_is_gnu"; then
 check_gcc_flag_conf "$CXX" 'c++' "-pipe"                   GXXFLAG_PIPE
 check_gcc_flag_conf "$CXX" 'c++' "-Os"                     GXXFLAG_OPTIMIZE_FOR_SIZE
 check_gcc_flag_conf "$CXX" 'c++' "-fpermissive"            GXXFLAG_F_PERMISSIVE
 check_gcc_flag_conf "$CXX" 'c++' "-fno-rtti"               GXXFLAG_F_NO_RTTI
 check_gcc_flag_conf "$CXX" 'c++' "-fno-exceptions"         GXXFLAG_F_NO_EXCEPTIONS
 check_gcc_flag_conf "$CXX" 'c++' "-fno-implicit-inline-templates" GXXFLAG_F_NO_IMPLICIT_INLINE_TEMPLATES
 check_gcc_flag_conf "$CXX" 'c++' "-fno-strict-aliasing"    GXXFLAG_F_NO_STRICT_ALIASING
 check_gcc_flag_conf "$CXX" 'c++' "-fhonor-std"             GXXFLAG_F_HONOR_STD
 #check_gcc_flag_conf "$CXX" 'c++' "-finline-limit=3000"     GXXFLAG_F_INLINE_LIMIT_3000
 check_gcc_flag_conf "$CXX" 'c++' "-fvtable-thunks"         GXXFLAG_F_VTABLE_THUNKS
 #check_gcc_flag_conf "$CXX" 'c++' "-fvtable-gc"             GXXFLAG_F_VTABLE_GC
 check_gcc_flag_conf "$CXX" 'c++' "-fno-enforce-eh-specs"   GXXFLAG_F_NO_ENFORCE_EH_SPECS
 check_gcc_flag_conf "$CXX" 'c++' "-fno-keep-static-consts" GXXFLAG_F_NO_KEEP_STATIC_CONSTS
 check_gcc_flag_conf "$CXX" 'c++' "-fno-use-cxa-atexit"     GXXFLAG_F_NO_USE_CXA_ATEXIT
 check_gcc_flag_conf "$CXX" 'c++' "-Wno-sign-compare"       GXXFLAG_W_NO_SIGN_COMPARE
 check_gcc_flag_conf "$CXX" 'c++' "-Wabi"                   GXXFLAG_W_ABI
 check_gcc_flag_conf "$CXX" 'c++' "-Wno-non-virtual-dtor"   GXXFLAG_W_NO_NON_VIRTUAL_DTOR

 log; empty_conf
fi	# cxx_is_gnu


check_env_var_conf STRICT ""

log; empty_conf

if test -n "$STRICT"; then

 if test -n "$cc_is_gnu"; then
  check_gcc_flag_conf "$CC"  'c'   "-Wbad-function-cast"     GCCFLAG_W_BAD_FUNCTION_CAST
  check_gcc_flag_conf "$CC"  'c'   "-Wno-bad-function-cast"  GCCFLAG_W_NO_BAD_FUNCTION_CAST
  check_gcc_flag_conf "$CC"  'c'   "-Wstrict-prototypes"     GCCFLAG_W_STRICT_PROTOTYPES
  check_gcc_flag_conf "$CC"  'c'   "-Werror-implicit-function-declaration" GCCFLAG_W_ERROR_IMPLICIT_FUNCTION_DECLARATION
  check_gcc_flag_conf "$CC"  'c'   "-Wdeprecated"            GCCFLAG_W_DEPRECATED
  check_gcc_flag_conf "$CC"  'c'   "-Wno-deprecated"         GCCFLAG_W_NO_DEPRECATED
  check_gcc_flag_conf "$CC"  'c'   "-Wdisabled-optimization" GCCFLAG_W_DISABLED_OPTIMIZATION
  #check_gcc_flag_conf "$CC"  'c'   "-Wfloat-equal"           GCCFLAG_W_FLOAT_EQUAL
  #check_gcc_flag_conf "$CC"  'c'   "-Wpacked"                GCCFLAG_W_PACKED
  #check_gcc_flag_conf "$CC"  'c'   "-Wpadded"                GCCFLAG_W_PADDED
  #check_gcc_flag_conf "$CC"  'c'   "-Wunreachable-code"      GCCFLAG_W_UNREACHABLE_CODE

  log; empty_conf
 fi	# cc_is_gnu


 if test -n "$cxx_is_gnu"; then
  check_gcc_flag_conf "$CXX" 'c++' "-Wbad-function-cast"     GXXFLAG_W_BAD_FUNCTION_CAST
  check_gcc_flag_conf "$CXX" 'c++' "-Wno-bad-function-cast"  GXXFLAG_W_NO_BAD_FUNCTION_CAST
  check_gcc_flag_conf "$CXX" 'c++' "-Wstrict-prototypes"     GXXFLAG_W_STRICT_PROTOTYPES
  check_gcc_flag_conf "$CXX" 'c++' "-fstrict-prototype"      GXXFLAG_F_STRICT_PROTOTYPE
  check_gcc_flag_conf "$CXX" 'c++' "-Werror-implicit-function-declaration" GXXFLAG_W_ERROR_IMPLICIT_FUNCTION_DECLARATION
  check_gcc_flag_conf "$CXX" 'c++' "-Wdeprecated"            GXXFLAG_W_DEPRECATED
  check_gcc_flag_conf "$CXX" 'c++' "-Wno-deprecated"         GXXFLAG_W_NO_DEPRECATED
  check_gcc_flag_conf "$CXX" 'c++' "-Wdisabled-optimization" GXXFLAG_W_DISABLED_OPTIMIZATION
  #check_gcc_flag_conf "$CXX" 'c++' "-Wfloat-equal"           GXXFLAG_W_FLOAT_EQUAL
  #check_gcc_flag_conf "$CXX" 'c++' "-Wpacked"                GXXFLAG_W_PACKED
  #check_gcc_flag_conf "$CXX" 'c++' "-Wpadded"                GXXFLAG_W_PADDED
  #check_gcc_flag_conf "$CXX" 'c++' "-Wunreachable-code"      GXXFLAG_W_UNREACHABLE_CODE
  check_gcc_flag_conf "$CXX" 'c++' "-Wsign-promo"            GXXFLAG_W_SIGN_PROMO
  check_gcc_flag_conf "$CXX" 'c++' "-Wpmf-conversions"       GXXFLAG_W_PMF_CONVERSIONS
  #check_gcc_flag_conf "$CXX" 'c++' "-Weffc++"               GXXFLAG_W_EFFCXX

  log; empty_conf
 fi	# cxx_is_gnu
fi	# STRICT


if test -n "$cc_is_gnu"; then
 logn 'gcc inc dir... '
 gcc_inc_dir=`LANG=C $CC -print-search-dirs | sed -ne 's/install: \(.*\)/\1include/gp'`
 log "$gcc_inc_dir"
 set_var_conf gcc_inc_dir
fi
if false && test -n "$cxx_is_gnu"; then
 logn 'g++ inc dir... '
 gxx_inc_dir=`LANG=C $CXX -print-search-dirs | sed -ne 's/install: \(.*\)/\1include/gp'`
 log "$gxx_inc_dir"
 set_var_conf gxx_inc_dir
fi
if test -n "$cc_is_gnu" -o -n "$cxx_is_gnu"; then
 log; empty_conf
fi


if  test -n "$have_linux_kernel_sources"; then

    # run once (multiple cached)
    build_lkversplit()
    {
	f=build_lkversplit
	u="Usage: $f"

	if  test "$#" -ne 0; then
	    die_argc $f
	fi

	if  test -z "$lkversplit_is_builded"; then
	    $CC -O lkversplit.c -o lkversplit
	    if	test $? -ge 2; then
		die "$f: error in compiling lkversplit.c"
	    fi

	    lkversplit_is_builded=yes
	fi
    }

    # run for each of lkversion
    build_lkversion()
    {
	f=build_lkversion
	u="Usage: $f lk-inc-dir"

	if  test "$#" -ne 1; then
	    die_argc $f
	fi

	test_lk_headers "$1" \
	|| die "$1 does not contains properly configured Linux kernel headers"

	$CC -o lkversion lkversion.c $CPPFLAGS $CFLAGS	\
		-DDONT_INCLUDE_LINUX_VERSION -I"$1"	\
		--include="$1/linux/version.h"		\
		-nostdinc -I$gcc_inc_dir -I/usr/include

	if  test $? -ge 2; then
	    die "$f: error in compiling lkversion.c"
	fi
    }

    run_lkversplit()
    {
	f=run_lkversplit
	u="Usage: $f lk-version"

	if  test "$#" -ne 1; then
	    die_argc $f
	fi

	build_lkversplit	# cached

	./lkversplit "$1" \
	|| die "$f: error in executing ./lkversplit $1 command"
    }

    run_lkversion()
    {
	f=run_lkversion
	u="Usage: $f lk-inc-dir"

	if  test "$#" -ne 1; then
	    die_argc $f
	fi

	build_lkversion "$1"

	./lkversion "$1" || die "$f: error in executing ./lkversion command"
    }

    unset_lkver()
    {
	f=unset_lkver
	u="Usage: $f var-name-base"

	if  test "$#" -ne 1; then
	    die_argc $f
	fi

	unset $1_major
	unset $1_minor
	unset $1_patchlevel
	unset $1_extra
	unset $1_base
	unset $1
    }

    _read_lkver()
    {
	f=_read_lkver
	u="Usage: $f var-name-base run-name lk-version | lk-inc-dir"

	if  test "$#" -ne 3; then
	    die_argc $f
	fi

	unset_lkver $1

	read $1_major $1_minor $1_patchlevel $1_extra << EOF
`$2 $3`
EOF

	if test	-z "`deref $1_major`" -o \
		-z "`deref $1_minor`" -o \
		-z "`deref $1_patchlevel`"; then
	    die "$f: error in executing $2 command"
	fi

	set_var $1_base "`deref $1_major`.`deref $1_minor`.`deref $1_patchlevel`"
	set_var $1      "`deref $1_base`""`deref $1_extra`"
    }

    read_lkversplit()
    {
	f=read_lkversplit
	u="Usage: $f var-name-base lk-version"

	if  test "$#" -ne 2; then
	    die_argc $f
	fi

	_read_lkver $1 run_lkversplit $2
    }

    read_lkversion()
    {
	f=read_lkversion
	u="Usage: $f var-name-base lk-inc-dir"

	if  test "$#" -ne 2; then
	    die_argc $f
	fi

	_read_lkver $1 run_lkversion $2
    }

    test_lk_headers()
    {
	f=check_lk_headers
	u="Usage: $f linux-inc-dir"

	if  test "$#" -ne 1; then
	    die_argc $f
	fi

	test -f "$1/linux/version.h" -a -f "$1/linux/autoconf.h"
    }

    find_lk_inc_dirs()
    {
	f=find_lk_inc_dirs
	u="Usage: $f linux-inc-dir ..."

	if  test "$#" -lt 1; then
	    die_argc $f
	fi

	for i in $@; do
	    if  test_lk_headers "$i"; then
		echo "$i"
		return 0
	    fi
	done

	return 1
    }

    find_lk_inc_dir_for_version()
    {
	f=find_lk_inc_dir2
	u="Usage: $f lk-version"

	if  test "$#" -ne 1; then
	    die_argc $f
	fi
	if test -z "$1"; then
	    die "$f: empty parameter"
	fi

	defincdirs="$INCDIRS"

	defincdirs="$defincdirs /usr/src/kernel-headers-$lkversion/include"
	defincdirs="$defincdirs /usr/src/kernel-headers-$lkversion_base/include"
	defincdirs="$defincdirs /usr/src/linux-$lkversion/include"
	defincdirs="$defincdirs /usr/src/linux-$lkversion_base/include"
	defincdirs="$defincdirs /usr/lib/kernel/$lkversion/include"
	defincdirs="$defincdirs /usr/lib/kernel/$lkversion_base/include"
	defincdirs="$defincdirs /usr/lib/kernel/include"
	defincdirs="$defincdirs /usr/src/linux/include"

	for i in $defincdirs; do
	    if  test_lk_headers "$i"; then
		read_lkversion _lkv "$i"
		if test "$lkversion" = "$_lkv"; then
		    # matched
		    echo "$i"
		    return 0
		fi
	    fi
	done
    }

    build_lkversplit

    if  test "$host_os" = "linux-gnu"; then
	logn "`fmt_prefix '  host Linux kernel release'` ... "
	host_LKVERSION="`uname -r`"
	log "$host_LKVERSION"
    fi


    if test -n "$LKSRCDIR"; then
	log "`fmt_prefix 'target Linux kernel source dir: '`""$LKSRCDIR"

	lk_inc_dir="$LKSRCDIR/include"

	test_lk_headers $lk_inc_dir \
	|| die "$LKSRCDIR does not contains properly configured Linux kernel headers";

	logn "`fmt_prefix 'target Linux kernel release'` ... "
	read_lkversion lkversion $lk_inc_dir
	log "$lkversion"

    elif test -n "$LKVERSION"; then
	logn "`fmt_prefix 'target Linux kernel release'` ... "
	log  "`fmt_suffix $LKVERSION` (supplied)"

	logn "`fmt_prefix 'target Linux kernel inc dir'` ... "

	read_lkversplit lkversion "$LKVERSION"
	lk_inc_dir="`find_lk_inc_dir_for_version \"$lkversion\"`"

	if test -n "$lk_inc_dir"; then
	    log  "`fmt_suffix $lk_inc_dir` (guessed)"
	else
	    log "not found"
	    die "Linux kernel headers version $LKVERSION is not found";
	fi
    elif test -n "$INCDIRS"; then
	logn "`fmt_prefix 'target Linux kernel inc dir'` ... "
	lk_inc_dir="`find_lk_inc_dirs $INCDIRS`"
	if test -n "$lk_inc_dir"; then
	    log  "`fmt_suffix $lk_inc_dir` (guessed)"
	else
	    log "not found"
	    die "Properly configured Linux kernel headers is not found";
	fi

	logn "`fmt_prefix 'target Linux kernel release'` ... "
	read_lkversion lkversion $lk_inc_dir
	log "$lkversion"
    else
	logn "`fmt_prefix 'target Linux kernel release'` ... "
	lkver=`uname -r`
	log  "`fmt_suffix $lkver` (default)"

	logn "`fmt_prefix 'target Linux kernel inc dir'` ... "

	read_lkversplit lkversion "$lkver"
	lk_inc_dir="`find_lk_inc_dir_for_version \"$lkversion\"`"

	if test -n "$lk_inc_dir"; then
	    log  "`fmt_suffix $lk_inc_dir` (guessed)"
	else
	    log "not found"
	    die "Linux kernel headers version $lkver is not found";
	fi
    fi

    dfconfig_time_var_conf lk_inc_dir           "$lk_inc_dir"
    dfconfig_time_var_conf lkversion            "$lkversion"
    dfconfig_time_var_conf lkversion_base       "$lkversion_base"
    dfconfig_time_var_conf lkversion_extra      "$lkversion_extra"
    dfconfig_time_var_conf lkversion_major      "$lkversion_major"
    dfconfig_time_var_conf lkversion_minor      "$lkversion_minor"
    dfconfig_time_var_conf lkversion_patchlevel "$lkversion_patchlevel"

    empty_conf

#   $CPP -I$lk_inc_dir $CPPFLAGS $CFLAGS lkconfig.h | fgrep lk_config_ >>.config.make
    $CPP lkconfig.h -DDONT_INCLUDE_LINUX_CONFIG  \
	-I"$lk_inc_dir" --include="$lk_inc_dir/linux/autoconf.h" | \
	fgrep lk_config_ >>.config.make

fi	# $have_linux_kernel_sources


log
