#!/bin/sh
#
# test compiler features and write .config.make;
# fragment with some utility functions.
#
# $Id: config-util.sh,v 1.2 2003/07/02 14:19:10 fedorov Exp $


_which()
{
    f=_which
    u="Usage: $f progname"

    if test "$#" -ne 1; then
	die_argc $f
    fi

    which "$1" >/dev/null 2>&1 && which "$1" 2>/dev/null
}


if  test -z "`_which printf`"; then
    printf()
    {
	shift
	echo "$@"
    }
fi


deref()
{
    f=deref
    u="Usage: $f varname"

    if test "$#" -ne 1; then
	die_argc $f
    fi

    eval echo $`echo "$1"`
}


set_var()
{
    f=set_var
    u="Usage: $f varname value"

    if test "$#" -ne 2; then
	die_argc $f
    fi

    eval "$1"='$2'
}


set_var_export()
{
    f=set_var_export
    u="Usage: $f varname value"

    if test "$#" -ne 2; then
	die_argc $f
    fi

    export "$1"
    eval   "$1"='$2'
}


set_var_conf()
{
    f=set_var_conf
    u="Usage: $f name [value]"

    if	test "$#" -lt 1 -o "$#" -gt 2; then
	die_argc $f
    fi

    if	test "$#" -eq 2; then
	_val="$2"
    else
	_val="`deref "$1"`"
    fi

    echo "`printf '%-40s' "$1"` = $_val" >>.config.make
}


dfconfig_time_var_conf()
{
    f=dfconfig_time_var_conf
    u="Usage: $f name [value]"

    if	test "$#" -lt 1 -o "$#" -gt 2; then
	die_argc $f
    fi

    if	test "$#" -eq 2; then
	_val="$2"
    else
	_val="`deref "$1"`"
    fi

    set_var_conf "dfconfig_time_$1" "$_val"
}


empty_conf()
{
    f=empty_conf
    u="Usage: $f"

    if	test "$#" -ne 0; then
	die_argc $f
    fi

    echo >>.config.make
}

