#!/bin/sh
#
# test compiler features and write .config.make;
# fragment with format functions.
#
# $Id: config-format.sh,v 1.3 2002/07/21 12:47:15 fedorov Exp $


truncate_slash()
{
    echo "$@" | sed -e 's./$..'
}

truncate_slashes()
{
    for d in "$@"; do truncate_slash $d; done
}

squeeze_double_slashes()
{
    echo "$@" | sed -e 's.//./.'
}


incdirs_to_incflags()
{
    for i in "$@"; do echo $ECHO_N " -I$i$ECHO_C"; done
}


########################################################################


fmt_prefix()
{
    printf '%-27s' "$*"
}


fmt_suffix()
{
    printf '%-36s' "$*"
}


fmt_cc_prefix()
{
    printf '%-69s' "$*"
}


fmt_name()
{
    f=fmt_name
    u="Usage: $f {-left|-right} strings ..."

    case $1 in
	-left  ) _fmt='%-14s'; shift ;;
	-right ) _fmt='%+14s'; shift ;;
	*      ) die "$f: no alignment option -left or -right given"
    esac

    printf $_fmt "$*"
}

fmt_right()
{
    fmt_name -right "$@"
}

fmt_left()
{
    fmt_name -left  "$@"
}

