#!/bin/sh
#
# test compiler features and write .config.make;
# fragment with check functions.
#
# $Id: config-check.sh,v 1.17 2003/07/06 06:58:49 fedorov Exp $


_cpu_vendor_os()
{
    f=_cpu_vendor_os
    u="Usage: $f cpu-vendor-os {1|2|3}"

    if	test "$#" -ne 2; then
	die_argc $f
    fi

    case "$2" in 1 | 2 | 3 ) ;;
	*) die "$f: only '1' or '2' or '3' are valid for 2nd parameter" ;;
    esac

    echo "$1" | sed "s/^\([^-]*\)-\([^-]*\)-\(.*\)$/\\$2/"
}


canonicalize_host_target()
{
    f=canonicalize_host_target
    u="Usage: $f {host|target}"

    if	test "$#" -ne 1; then
	die_argc $f
    fi

    case "$1" in host | target ) ;;
	*) die "$f: only 'host' or 'target' are valid for parameter" ;;
    esac

    if _alias_sub=`./config.sub \`deref $1\``; then :
    else
	die "error in executing ./config.sub $2"
    fi

    set_var_export "$1"                        $_alias_sub
    set_var_export "$1_cpu"    `_cpu_vendor_os $_alias_sub 1`
    set_var_export "$1_vendor" `_cpu_vendor_os $_alias_sub 2`
    set_var_export "$1_os"     `_cpu_vendor_os $_alias_sub 3`
}


check_host_target_var()
{
    f=check_host_target_var
    u="Usage: $f {host|target}"

    if	test "$#" -ne 1; then
	die_argc $f
    fi

    case "$1" in host | target ) ;;
	*) die "$f: only 'host' or 'target' are valid for parameter" ;;
    esac

    _name="`printf '%+6s' $1` system type"

    logn "`fmt_prefix \"checking $_name\"` ... "

    if test -n "`deref $1`"; then
	_src="(supplied)"
    else
	if test "$1" =  "host"; then
	    _src="(guessed)"
	    if host="`./config.guess`"; then :
	    else
		die "can not guess host type; you must specify one with 'host' env. var."
	    fi
	else	# "$1" = "target"
	    _src="(default)"
	    target="$host"
	fi
    fi

    canonicalize_host_target $1
    log "`fmt_suffix \`deref $1\`` $_src"
}


check_host_target_var_conf()
{
    f=check_host_target_var_conf
    u="Usage: $f {host|target}"

    if	test "$#" -ne 1; then
	die_argc $f
    fi

    case "$1" in host | target ) ;;
	*) die "$f: only 'host' or 'target' are valid for parameter" ;;
    esac

    check_host_target_var "$1"

    set_var_conf "$1"
    set_var_conf "$1_cpu"
    set_var_conf "$1_vendor"
    set_var_conf "$1_os"
}


########################################################################


_check_env_var()
{
    f=_check_env_var
    u="Usage: $f var_name default_value"

    if	test "$#" -ne 2; then
	die_argc $f
    fi

    _val=`deref $1`

    if	test -n "$_val"
    then echo "$_val"; _rc=0	# supplied
    else echo "$2"   ; _rc=1	# default
    fi

    return $_rc
}


check_env_var()
{
    f=check_env_var
    u="Usage: $f [-left|-right] [-truncate] [-guessed] var_name default_value [var_name_to_display]"

    if	test "$#" -lt 2 -o "$#" -gt 6; then
	die_argc $f
    fi

    while true; do
	case $1 in
	    -left | -right ) _align=$1      ; shift ;;
	    -truncate      ) _truncate="yes"; shift ;;
	    -guessed       ) _guessed="yes" ; shift ;;
	    *              )                  break ;;
	esac
    done
    if test -z "$_align"; then _align="-left"; fi

    _name="$1"; if test "$#" -eq 3; then _name="$3"; fi

    aligned_name="`fmt_name $_align \"$_name\"`"
    logn "`fmt_prefix checking for "$aligned_name"` ... "

    if _val=`_check_env_var "$1" "$2"`; then
	_status="(supplied)"
    else
	if test -n "$_guessed"; then
	    _status="(guessed)"
	else
	    _status="(default)"
	fi
    fi

    if test -n "$_truncate"; then
	_val="`truncate_slash "$_val"`"
    fi

    log "`fmt_suffix \"$_val\"` $_status"
    echo "$_val"
}


# check and write to .config.make
check_env_var_conf()
{
    f=check_env_var_conf
    u="Usage: $f [-left|-right] [-truncate] [-guessed] var_name default_value [var_name_to_display]"

    if	test "$#" -lt 2 -o "$#" -gt 6; then
	die_argc $f
    fi

    _val=`check_env_var "$@"`

    while true; do
	case $1 in
	    -left | -right | -truncate | -guessed ) shift ;;
	    *                                     ) break ;;
	esac
    done

    dfconfig_time_var_conf "$1" "$_val"
    set_var_export         "$1" "$_val"
}


########################################################################


_normalize_arch()
{
    f=_normalize_arch
    u="Usage: $f arch"

    if	test "$#" -ne 1; then
	die_argc $f
    fi

    echo "$1" | sed -e s/i.86/i386/ -e s/sun4u/sparc64/ -e s/arm.*/arm/ -e s/sa110/arm/
}

normalize_arch()
{
    f=normalize_arch
    u="Usage: $f arch"

    if	test "$#" -ne 1; then
	die_argc $f
    fi

    logn "`fmt_prefix \"normalize    ARCH\"` ... "
    _val=`_normalize_arch $1`
    log "$_val"
    echo $_val
}


########################################################################


_check_prog_exists()
{
    f=_check_prog_exists
    u="Usage: $f progname"

    if	test "$#" -ne 1; then
	die_argc $f
    fi

    if  test -n "`_which $1`"
    then echo "yes"; return 0;
    else echo "no" ; return 1;
    fi
}

check_prog_exists()
{
    f=check_prog_exists
    u="Usage: $f progname [name_to_display]"

    if	test "$#" -lt 1 -o "$#" -gt 2; then
	die_argc $f
    fi

    _name="$1"; if test "$#" -eq 2; then _name="$2"; fi

    logn "`fmt_prefix checking whether $_name exists` ... "

    _val=`_check_prog_exists "$1"`; _rc=$?
    log "$_val"
    return $_rc
}


########################################################################


_check_cc_works()
{
    f=_check_cc_works
    u="Usage: $f progname"

    if	test "$#" -ne 1; then
	die_argc $f
    fi

    cat > .conftest.c << EOF
main() { return 0; }
EOF

    if $1 .conftest.c >/dev/null 2>&1
    then echo "yes"; _rc=0
    else echo "no" ; _rc=1
    fi

    rm -f .conftest* a.out
    return $_rc;
}

check_cc_works()
{
    f=check_cc_works
    u="Usage: $f progname [name_to_display]"

    if	test "$#" -lt 1 -o "$#" -gt 2; then
	die_argc $f
    fi

    _name="$1"; if test "$#" -eq 2; then _name="$2"; fi

    logn "`fmt_cc_prefix checking whether $_name works` ... "

    _val=`_check_cc_works $1`; _rc=$?
    log "$_val"
    return $_rc;
}


check_cc_exists_and_works()
{
    f=check_cc_exists_and_works
    u="Usage: $f progname [name_to_display]"

    if	test "$#" -lt 1 -o "$#" -gt 2; then
	die_argc $f
    fi

    if check_prog_exists "$@" && check_cc_works "$@"; then
	return 0
    fi

    return 1
}


_check_cc_is_gnu()
{
    f=_check_cc_is_gnu
    u="Usage: $f progname {'c'|'c++'}"

    if	test "$#" -ne 2; then
	die_argc $f
    fi

    case "$2" in
	c++ ) _file=.conftest.cc ;;
	c   ) _file=.conftest.c  ;;
	*   ) die "$f: 2nd parameter is invalid, only 'c' or 'c++' allowed" ;;
    esac

    cat > $_file << EOF
#ifdef __GNUC__
main() { return 0; }
#else
main() { ret 0; } /* wittingly wrong syntax */
#endif
EOF

    if $1 $_file -x $2 >/dev/null 2>&1	# -x lang is gcc option
    then echo "yes"; _rc=0
    else echo "no" ; _rc=1
    fi

    rm -f .conftest* a.out
    return $_rc;
}

check_cc_is_gnu()
{
    f=check_cc_is_gnu
    u="Usage: $f progname {'c'|'c++'} [name_to_display]"

    if	test "$#" -lt 2 -o "$#" -gt 3; then
	die_argc $f
    fi

    case "$2" in
	c++ ) _lang="C++" ;;
	c   ) _lang="C  "  ;;
	*   ) die "$f: 2nd parameter is invalid, only 'c' or 'c++' allowed" ;;
    esac

    _name="$1"; if test "$#" -eq 3; then _name="$3"; fi

    logn "`fmt_cc_prefix checking whether $_name is GNU $_lang compiler` ... "

    _val=`_check_cc_is_gnu "$1" "$2"`; _rc=$?
    log "$_val"
    return $_rc;
}

check_cc_is_gnu_conf()
{
    f=check_cc_is_gnu_conf
    u="Usage: $f progname {'c'|'c++'} [name_to_display]"

    if	test "$#" -lt 2 -o "$#" -gt 3; then
	die_argc $f
    fi

    case "$2" in
	c++ ) _lang_="cxx" ;;
	c   ) _lang_="cc"  ;;
	*   ) die "$f: 2nd parameter is invalid, only 'c' or 'c++' allowed" ;;
    esac

    check_cc_is_gnu "$@"; _rc=$?
    if test $_rc -eq 0; then _val=yes; else unset _val; fi

    dfconfig_time_var_conf "${_lang_}_is_gnu" "$_val"
    set_var_export         "${_lang_}_is_gnu" "$_val"

    return $_rc
}


########################################################################


# returns supplied flag argument on success or empty on failure
_check_gcc_flag()
{
    f=_check_gcc_flag
    u="Usage: $f gccname {'c'|'c++'} flag"

    if	test "$#" -ne 3; then
	die_argc $f
    fi

    case "$2" in c++ | c ) ;;
	*) die "$f: 2nd parameter is invalid, only 'c' or 'c++' allowed" ;;
    esac

    if $1 -W -Werror -x $2 $3 -S -o /dev/null /dev/null >/dev/null 2>&1
    then echo "$3"; _rc=0
    else echo ""  ; _rc=1
    fi

    return $_rc;
}

# returns supplied flag argument on success or empty on failure
check_gcc_flag()
{
    f=check_gcc_flag
    u="Usage: $f gccname {'c'|'c++'} flag"

    if	test "$#" -ne 3; then
	die_argc $f
    fi

    case "$2" in
	c++ ) _compiler="C++" ;;
	c   ) _compiler="C  " ;;
	*   ) die "$f: 2nd parameter is invalid, only 'c' or 'c++' allowed" ;;
    esac

    logn "`fmt_cc_prefix \"checking whether $_compiler compiler accepts $3\"` ... "

    _val=`_check_gcc_flag "$@"`; _rc=$?

    if test -n "$_val"; then
	log 'yes'
    else
	log 'no'
    fi

    echo "$_val"
    return $_rc;
}

check_gcc_flag_conf()
{
    f=check_gcc_flag_conf
    u="Usage: $f gccname {'c'|'c++'} flag flag_var_name"

    if	test "$#" -ne 4; then
	die_argc $f
    fi

    case "$2" in c++ | c ) ;;
	*) die "$f: 2nd parameter is invalid, only 'c' or 'c++' allowed" ;;
    esac

    _val=`check_gcc_flag "$1" "$2" "$3"`
    set_var_conf "$4" "$_val"
}

