#!/usr/bin/perl -w
#
# filter 'cvs status -v' command output and show files which are
# newer then last project release tag.
#
# usage: checkrel.pl files ...
#
# (C) Vyacheslav V. Mukhortov <mukhort@inp.nsk.su>, 2000
# (C) Dmitry V. Bondarev <bondarev@inp.nsk.su>, 2001
#
# $Id: checkrel.pl,v 1.5 2003/07/02 10:19:25 fedorov Exp $

use strict ;
use integer ;
use File::Basename ;

( my $NAME = $0 ) =~ s!^.*/!! ; # remove path from the program name

print "Usage: $NAME files ...\n"
    unless @ARGV ;

my $cmd = "cvs status -v @ARGV" ;
open IN, "$cmd |"
    or die "Can't open a pipe to `$cmd' - $!\n" ;

# get repository root path
my $cvs_root_file ;
{ no strict ; $cvs_root_file = dirname( $ARGV[0] )."/CVS/Root" ; }
open CVS_ROOT, "< $cvs_root_file"
    or die "$NAME: DIED! Couldn't open file `$cvs_root_file' - $!\n" ;
( my $repository_root_path = <CVS_ROOT> ) =~ s!^.*:!! ;
close CVS_ROOT ;
chomp $repository_root_path ;

while ( <IN> )
{
    # get file's name and status
    chomp;
    my $str = $_;
    if ( $str =~ m!File:\s(\S*)\s*Status:\s(.*)!o ) # look for start string
    {
	my $fileName   = $1 ;
	my $fileStatus = $2 ;

	<IN> ; # skip empty line

	# get working revision
	$str = <IN> ;
	chomp $str ;
	$str =~ m!\s*Working\srevision:\s*([\d\.]+)(.*)!o
	    or die "Unexpected string: $str\n" ;
	my $workingRevision = $1 ;

	# get repository revision and repository file
	$str = <IN> ;
	chomp $str ;
	$str =~ m!\s*Repository\srevision:\s+([\d\.]+)\s+(.+)\s*$!o
	    or die "Unexpected string: $str\n" ;
	my $repositoryRevision = $1 ;

	# take last field ( i.e. filename )
	my ( $repositoryFile ) = reverse split( /\s+/, $2 ) ;
	$repositoryFile =~ s!^$repository_root_path/?!! ;
	$repositoryFile =~ s!,v$!!o ; # remove ",v" from filename

	# get sticky tag
	$str = <IN> ;
	chomp $str ;
	$str =~ m!\s*Sticky\sTag:\s*(.*)!o
	    or die "Unexpected string: $str\n" ;
	my $stickyTag = $1 ;

	<IN>; <IN>; <IN>; # skip 3 lines

	my $tag         = '' ;
	my $tagRevision = '' ;

	# get tag and tagRevision if possible
	$str = <IN> ;
	chomp $str ;
	if ( $str =~ m!\s*Existing\sTags?.*!o )
	{
	    $str = <IN> ;
	    chomp $str ;
	    if ( $str =~ m!\s*(\S*)\s*\(revision:\s(\S*)\)!o )
	    {
		$tag         = $1 ;
		$tagRevision = $2 ;
	    }
	    else
	    {
		$str =~ m!\s*No\sTags\sExist!o
		    or die "Unexpected string: $str\n" ;
	    }
	}

	# prepare report
	my $message = '' ;
	$message .= "\tWarning: working revision($workingRevision) is not equal to\n".
	            "\t      repository revision($repositoryRevision)\n"
	    if $workingRevision ne $repositoryRevision ;

	$message .= "\tWarning: sticky tag exists ($stickyTag)\n"
	    if $stickyTag ne "(none)" ;

	$message .= "\tWarning: file isn't up to date ($fileStatus)\n"
	    if $fileStatus ne "Up-to-date" ;

	$message .= "\tproject tag revision: $tagRevision\n".
	            "\t    working revision: $workingRevision\n".
                    "\t----> new project release needed!\n"
	    if $workingRevision ne $tagRevision ;

	print "$repositoryFile\n\tproject tag         : $tag\n$message\n"
	    if $message ;
    }
}

exit 0 ;
