#!/bin/bash
#
# $Id: check-lkh-patches.sh,v 1.2 2002/07/16 06:48:10 fedorov Exp $
#
# check Linux kernel header patch files for specified kernel version
# in specified patch directory against Linux kernel base directory

if test "$#" -lt 2 ; then
   echo 1>&2
   echo "Usage: $0 patch-dir lk-base-dir ..." 1>&2
   echo 1>&2
   exit 1
fi

echo

scriptdir=`dirname "$0"`

. "$scriptdir/lk-patch-functions.sh"

patch_dir="$1"

shift 1


function on_match()
{
  if test "$#" -ne 2 ; then
     echo "Usage: on_match lk-inc-dir patch-file" 1>&2
     exit 1
  fi

  #echo "on_match: $@"
  (cd "$1" && patch --dry-run -p0) <"$2" || exit $?
}


for d
do

  _d=`basename "$d"`
  v=`echo "$_d" | cut -d. -f1-3 -`

  echo "--------------------------------------------------------------"
  echo
  patchfile_match_loop "$patch_dir" "$d/include" `"$scriptdir/lkversplit" "$v"`

done

