#!/bin/bash
#
# $Id: check-lkh-patch.sh,v 1.2 2002/07/16 06:48:09 fedorov Exp $
#
# check specified Linux kernel header patch file
# against Linux kernel base directory

if test "$#" -lt 2 ; then
   echo 1>&2
   echo "Usage: $0 patch-file lk-base-dir ..." 1>&2
   echo 1>&2
   exit 1
fi

echo

file="$1"
shift

for d; do
	echo "checking against $d ..."
	(cd "$d/include" && patch --dry-run -p0) <"$file"
	echo
done

