#include <linux/sched.h>

struct es_param esi, eso;
int i, j, n, bg, po, qo, cp, cq, mp, mq, v, cpo, cqo, argc, help, info, rtrn;
int qid[ES_MAX_RQ];
char ** argv;
char cmd[10][40];
char buf[80], command[80];
char eserr[ES_MAX_ERR][80];
char ver[10]={"1.5"};
char program[10]={"esep"};
char date[30]={"December 28, 1997"};
char project[50]={"Evolution Scheduling and Evolving Processes"};

int check_init(int margc, char **margv)
{
  argc=margc;
  argv=margv;

  sprintf(eserr[0], "%s", "This is a correct message. Don't worry!");
  sprintf(eserr[1], "%s", "Syscall returns error. Please refer to sched.c program.");
  sprintf(eserr[2], "%s", "It seems to have problems to verify read.");
  sprintf(eserr[3], "%s", "It seems to have problems to verify write.");
  sprintf(eserr[4], "%s", "Queue I.D. is invalid.");
  sprintf(eserr[5], "%s", "Queue objective function is invalid.");
  sprintf(eserr[6], "%s", "Process objective function is invalid.");
  sprintf(eserr[7], "%s", "PID is incorrect.");
  sprintf(eserr[8], "%s", "Kernel couldn't find this PID.");
  sprintf(eserr[9], "%s", "I couldn't change the key_switch for you.");
  sprintf(eserr[10], "%s", "I couldn't change the default policy for you.");
  sprintf(eserr[11], "%s", "The policy is corrently used.");
  sprintf(eserr[12], "%s", "There is a problem to change the default queue objective function.");
  sprintf(eserr[13], "%s", "There is a problem to change the default process objective function.");
  sprintf(eserr[14], "%s", "You are not a super user. I couldn't change anything for you.");
  sprintf(eserr[15], "%s", "Your policy is incorrect. Please try ES_SCHED_PRIORITY(0) or ES_SCHED_ES(3).");
  sprintf(eserr[16], "%s", "System call has problems.");

  esi.default_queue_id = 0;
  for(i=0; i<ES_MAX_OBJ; i++)
  {
    esi.default_queue_objective_function[i]=0;
    esi.default_process_objective_function[i]=0;
    qid[i]=0;
  }
  return ES_TRUE;
}

int check_bg()
{
  bg=0;
  for(i=1; i<argc; i++)
  {
    if(strcmp(argv[i], "-bg")==0) bg=1;
  }
  return ES_TRUE;
}

int check_help()
{
  help=0;
  for(i=1; i<argc; i++)
  {
    if(strcmp(argv[i], "-help")==0) help=1;
    if(strcmp(argv[i], "-h")==0) help=1;
  }
  return ES_TRUE;
}

int check_info()
{
  info=0;
  if(argc==1) 
  {
    info=1;
    return(ES_TRUE);
  }
  for(i=1; i<argc; i++)
  {
    if(strcmp(argv[i], "-info")==0) info=1;
    if(strcmp(argv[i], "-i")==0) info=1;
  }
  return ES_TRUE;
}

int check_ver()
{
  v=0;
  if(argc==1) 
  {
    return(ES_TRUE);
  }
  for(i=1; i<argc; i++)
  {
    if(strcmp(argv[i], "-ver")==0) v=1;
    if(strcmp(argv[i], "-v")==0) v=1;
  }
  return ES_TRUE;
}

int check_q()
{
  for(i=1; i<argc; i++)
  {
    if(strcmp(argv[i], "-q")==0)
    {
      if((ES_MIN_RQ<=atoi(argv[i+1]))&&(atoi(argv[i+1])<ES_MAX_RQ))
      {
        esi.default_queue_id=atoi(argv[i+1]);
      }
      else
      {
        return ES_ERR_QUEUE_ID;
      }
      i=argc;
    }
  }
  return ES_TRUE;
}

int check_cq()
{
  cq=0;
  for(i=1; i<argc; i++)
  {
    if(strcmp(argv[i], "-cq")==0)
    {
      if((ES_MIN_RQ<=atoi(argv[i+1]))&&(atoi(argv[i+1])<ES_MAX_RQ))
      {
        esi.default_queue_id=atoi(argv[i+1]);
      }
      else
      {
        return ES_ERR_QUEUE_ID;
      }
      i=argc;
      cq=1;
    }
  }
  return ES_TRUE;
}

int check_cp()
{
  cp=0;
  for(i=1; i<argc; i++)
  {
    if(strcmp(argv[i], "-cp")==0)
    {
      if(strcmp(argv[i+1],"ES")==0||strcmp(argv[i+1],"es")==0)
        sprintf(argv[i+1], "%s", "3");
      if(strcmp(argv[i+1],"PR")==0||strcmp(argv[i+1],"pr")==0)
        sprintf(argv[i+1], "%s", "0");

      if((atoi(argv[i+1])==ES_SCHED_ES)||(atoi(argv[i+1])==ES_SCHED_PRIORITY))
      {
        esi.default_policy=atoi(argv[i+1]);
      }
      else
      {
        return ES_ERR_POLICY;
      }
      i=argc;
      cp=1;
    }
  }
  return ES_TRUE;
}

int check_mp()
{
  mp=0;
  for(i=1; i<argc; i++)
  {
    if(strcmp(argv[i], "-mp")==0)
    {
      mp=1;
      if(0<atoi(argv[i+1]))
      {
        esi.default_pid=atoi(argv[i+1]);
      }
      else
      {
        return ES_ERR_PID;
      }
      i=argc;
    }
  }
  return ES_TRUE;
}

int check_mq()
{
  mq=0;
  for(i=1; i<argc; i++)
  {
    if(strcmp(argv[i], "-mq")==0)
    {
      mq=1;
      if((ES_MIN_RQ<=atoi(argv[i+1]))&&(atoi(argv[i+1])<ES_MAX_RQ))
      {
        esi.default_queue_id=atoi(argv[i+1]);
      }
      else
      {
        mq=0;
        return ES_ERR_QUEUE_ID;
      }
      i=argc;
    }
  }
  return ES_TRUE;
}

int check_po()
{
  n=0;
  po=0;
  for(i=1; i<argc; i++)
  {
    if(strcmp(argv[i], "-po")==0)
    {
      po=1;
      for(j=i+1; j<argc&&n<ES_MAX_OBJ; j++)
      {
        if((0<=atoi(argv[j]))&&(atoi(argv[j])<=100))
        {
          esi.default_process_objective_function[n]=atoi(argv[j]);
          n++;
        }
        else
        {
          return ES_ERR_PROCESS_OBJECTIVE_FUNCTION;
        }
      }
      i=argc;
    }
  }
  return ES_TRUE;
}

int check_cpo()
{
  n=0;
  cpo=0;
  for(i=1; i<argc; i++)
  {
    if(strcmp(argv[i], "-cpo")==0)
    {
      cpo=1;
      for(j=i+1; j<argc&&n<ES_MAX_OBJ; j++)
      {
        if((0<=atoi(argv[j]))&&(atoi(argv[j])<=100))
        {
          esi.default_process_objective_function[n]=atoi(argv[j]);
          n++;
        }
        else
        {
          return ES_ERR_DEFAULT_PROCESS_OBJECTIVE_FUNCTION;
        }
      }
      i=argc;
    }
  }
  return ES_TRUE;
}

int check_qo()
{
  n=0;
  qo=0;
  for(i=1; i<argc; i++)
  {
    if(strcmp(argv[i], "-qo")==0)
    {
      qo=1;
      for(j=i+1; j<argc&&n<ES_MAX_OBJ; j++)
      {
        if((0<=atoi(argv[j]))&&(atoi(argv[j])<=100))
        {
          esi.default_queue_objective_function[n]=atoi(argv[j]);
          n++;
        }
        else
        {
          return ES_ERR_QUEUE_OBJECTIVE_FUNCTION;
        }
      }
      i=argc;
    }
  }
  return ES_TRUE;
}

int check_cqo()
{
  n=0;
  cqo=0;
  for(i=1; i<argc; i++)
  {
    if(strcmp(argv[i], "-cqo")==0)
    {
      cqo=1;
      for(j=i+1; j<argc&&n<ES_MAX_OBJ; j++)
      {
        if((0<=atoi(argv[j]))&&(atoi(argv[j])<=100))
        {
          esi.default_queue_objective_function[n]=atoi(argv[j]);
          n++;
        }
        else
        {
          return ES_ERR_DEFAULT_QUEUE_OBJECTIVE_FUNCTION;
        }
      }
      i=argc;
    }
  }
  return ES_TRUE;
}

int check_command()
{
  n=0;
  for(i=1; (i<argc)&&(i<=10); i++)
  {
    if((strcmp(argv[i], "-q")==0)||
       (strcmp(argv[i], "-po")==0)||
       (strcmp(argv[i], "-qo")==0)||
       (strcmp(argv[i], "-cp")==0)||
       (strcmp(argv[i], "-cq")==0)||
       (strcmp(argv[i], "-mp")==0)||
       (strcmp(argv[i], "-mq")==0)||
       (strcmp(argv[i], "-cpo")==0)||
       (strcmp(argv[i], "-cqo")==0)||
       (strcmp(argv[i], "-v")==0)||
       (strcmp(argv[i], "-ver")==0)||
       (strcmp(argv[i], "-i")==0)||
       (strcmp(argv[i], "-info")==0)||
       (strcmp(argv[i], "-h")==0)||
       (strcmp(argv[i], "-help")==0)||
       (strcmp(argv[i], "-bg")==0))
    {
      i=argc;
    }
    else
    {
      sprintf(cmd[n], "%s", argv[i]);
      n++;
    }
  }
  sprintf(command, "%s", "");
  for(i=0; i<n; i++) sprintf(command, "%s %s", command, cmd[i]);
  if(bg==1) sprintf(command, "%s &", command);
  if((strlen(command)>0)&&(command[0]==' '))
    sprintf(command, "%s", &command[1]);
  return ES_TRUE;
}

int run_command()
{
  if((rtrn=get_status())!=ES_TRUE) run_error(rtrn, "rc");

  if(esi.default_queue_id > 0)
  {
    if((rtrn=syscall(SYS_ES_NICE, ES_SET_DEFAULT_QUEUE_ID, &esi)) != ES_TRUE)
      run_error(rtrn, "rc");
  } 
  if(po==1)
  {
    if((rtrn=syscall(SYS_ES_NICE, ES_SET_DEFAULT_PROCESS_OBJECTIVE_FUNCTION, 
      &esi)) != ES_TRUE) 
      run_error(rtrn, "rc");
  }
  if(qo==1)
  {
    if((rtrn=syscall(SYS_ES_NICE, ES_SET_DEFAULT_QUEUE_OBJECTIVE_FUNCTION,
      &esi)) != ES_TRUE) 
      run_error(rtrn, "rc");
  }

  if((rtrn=system(command)) != ES_TRUE_SYSTEM_CALL) 
  {
    printf("es:(%s) command error\n", command);
    return ES_ERR_SYSTEM_CALL;
  }

  if(esi.default_queue_id > 0)
  {
    if((rtrn=syscall(SYS_ES_NICE, ES_SET_DEFAULT_QUEUE_ID, &eso)) != ES_TRUE)
      run_error(rtrn, "rc");
  } 

  if (po==1)
  {
    if((rtrn=syscall(SYS_ES_NICE, ES_SET_DEFAULT_PROCESS_OBJECTIVE_FUNCTION, 
      &eso)) != ES_TRUE) 
      run_error(rtrn, "rc");
  }

  if (qo==1)
  {
    if((rtrn=syscall(SYS_ES_NICE, ES_SET_DEFAULT_QUEUE_OBJECTIVE_FUNCTION, 
      &eso)) != ES_TRUE) 
      run_error(rtrn, "rc");
  }

  exit(ES_TRUE);
}

int print_es_info()
{
  printf("PCY QID  CTX  POF             QOF             SYS\n");
  printf(" %s   %1d %4d %3d%3d%3d%3d%3d %3d%3d%3d%3d%3d  %d %d %d %d %d\n",
    "ES",
    eso.default_queue_id,
    eso.context_switch,
    eso.default_process_objective_function[0],
    eso.default_process_objective_function[1],
    eso.default_process_objective_function[2],
    eso.default_process_objective_function[3],
    eso.default_process_objective_function[4],
    eso.default_queue_objective_function[0],
    eso.default_queue_objective_function[1],
    eso.default_queue_objective_function[2],
    eso.default_queue_objective_function[3],
    eso.default_queue_objective_function[4],
    eso.base_free,
    eso.system_free,
    eso.cpu_free,
    eso.mem_free,
    eso.disk_free);

  printf("\n");
  printf(" QID   RUN GUA  FIT     QOF\n");

  for (i=1; i< ES_MAX_RQ; i++)
  {
    if(qid[i]==ES_TRUE)
    {
      printf("   %1d  %4d %1d/%1d %3d/%3d %3d%3d%3d%3d%3d\n", 
        i,
        eso.queue_run[i], 
        eso.queue_guarantee_value[i],
        eso.queue_guarantee_value_last[i],
        eso.queue_fitness_value[i],
        eso.queue_fitness_value_last[i],
        eso.queue_objective_function[i][0],
        eso.queue_objective_function[i][1],
        eso.queue_objective_function[i][2],
        eso.queue_objective_function[i][3],
        eso.queue_objective_function[i][4]);
    }
  }

  printf("\n");
  printf("  PID QID  RUN CNT PRI RTP GUA FIT      POF             QOF             CMD\n");

  for (i=0; i< eso.process_no; i++)
  {
    eso.comm[i][8]='\0';
    printf("%5d   %1d  %3d  %2d  %2d  %2d %1d/%d %3d/%3d %3d%3d%3d%3d%3d %3d%3d%3d%3d%3d  %s\n", 
      eso.pid[i], 
      eso.rq_queue_id[i], 
      eso.rq_process_run[i], 
      eso.counter[i], 
      eso.priority[i], 
      eso.rt_priority[i], 
      eso.rq_process_guarantee_value[i],
      eso.rq_process_guarantee_value_last[i],
      eso.rq_process_fitness_value[i],
      eso.rq_process_fitness_value_last[i],
      eso.rq_process_objective_function[i][0],
      eso.rq_process_objective_function[i][1],
      eso.rq_process_objective_function[i][2],
      eso.rq_process_objective_function[i][3],
      eso.rq_process_objective_function[i][4],
      eso.rq_queue_objective_function[i][0],
      eso.rq_queue_objective_function[i][1],
      eso.rq_queue_objective_function[i][2],
      eso.rq_queue_objective_function[i][3],
      eso.rq_queue_objective_function[i][4],
      eso.comm[i]);
  }
  exit(ES_TRUE);
}

int print_pr_info()
{
  printf("PCY  CTX\n");
  printf(" %s %4d\n",
    "PR",
    eso.context_switch);

  printf("\n"); 
  printf("  PID RUN CNT PRI RTP  CMD\n");

  for (i=0; i< eso.process_no; i++)
  {
    eso.comm[i][8]='\0';
    printf("%5d %3d  %2d  %2d  %2d  %s\n", 
      eso.pid[i], 
      eso.rq_process_run[i], 
      eso.counter[i], 
      eso.priority[i],
      eso.rt_priority[i],
      eso.comm[i]);
  }

  exit(ES_TRUE);
}

int print_info()
{
  if((rtrn=get_status())!=ES_TRUE) run_error(rtrn, "pi"); 

  if(eso.default_policy==ES_SCHED_ES)
  {
    if((rtrn=print_es_info())!=ES_TRUE)
      run_error(rtrn, "ri");
  }
  else
  {
    if((rtrn=print_pr_info())!=ES_TRUE)
      run_error(rtrn, "ri");
  }

  exit(ES_TRUE);
}

int run_cq()
{
  if((rtrn=syscall(SYS_ES_NICE, ES_SET_DEFAULT_QUEUE_ID, &esi)) != ES_TRUE)
    run_error(rtrn, "rcq");

  exit(ES_TRUE);
}

int run_cp()
{
  if((rtrn=syscall(SYS_ES_NICE, ES_SET_DEFAULT_POLICY, &esi)) != ES_TRUE)
    run_error(rtrn, "rcp");

  exit(ES_TRUE);
}

int run_mp()
{
  if(po!=ES_TRUE) return ES_ERR_PROCESS_OBJECTIVE_FUNCTION;
  if((rtrn=syscall(SYS_ES_NICE, ES_SET_PROCESS_OBJECTIVE_FUNCTION, &esi)) 
    != ES_TRUE)
    run_error(rtrn, "rmp");

  exit(ES_TRUE);
}

int run_mq()
{
  if(qo!=ES_TRUE) return ES_ERR_QUEUE_OBJECTIVE_FUNCTION;
  if((rtrn=syscall(SYS_ES_NICE, ES_SET_QUEUE_OBJECTIVE_FUNCTION, &esi)) 
    != ES_TRUE)
    run_error(rtrn, "rmq");

  exit(ES_TRUE);
}

int run_cpo()
{
  if((rtrn=syscall(SYS_ES_NICE, ES_SET_DEFAULT_PROCESS_OBJECTIVE_FUNCTION, 
    &esi)) != ES_TRUE)
    run_error(rtrn, "rcpo");

  exit(ES_TRUE);
}

int run_cqo()
{
  if((rtrn=syscall(SYS_ES_NICE, ES_SET_DEFAULT_QUEUE_OBJECTIVE_FUNCTION, 
    &esi)) != ES_TRUE)
    run_error(rtrn, "rcqo");

  exit(ES_TRUE);
}

int print_ver()
{
  printf("%s version: %s\n", argv[0], ver);

  exit(ES_TRUE);
}

int print_help()
{
  printf("usage: Evolution Scheduling and Evolving Processes   Ver:%s  Date:%s\n", ver, date);
  printf("\n");
  printf("    %s [\"commands args...\"] [-options...]\n", argv[0]);
  printf("\n");
  printf("  where options include:\n");
  printf("    -help|-h                         print out this message\n");
  printf("    -info|-i                         print out scheduling information\n");
  printf("    -cp pcy                          change default policy\n");
  printf("    -cq qid                          change default qid\n");
  printf("    -cpo obj...                      change default process objective function\n");
  printf("    -cqo obj...                      change default queue objective function\n");
  printf("    -mp pid -po obj... [-qo obj...]  modify current process objective function\n");
  printf("    -mq qid -qo obj...               modify current queue objective function\n");
  printf("    -q qid                           declare qid for commands\n");
  printf("    -po obj...                       declare process obj func for commands\n");
  printf("    -qo obj...                       declare queue obj func for commands\n");
  printf("    -bg                              execute in background for commands\n");
  printf("\n");
  printf("    pcy={0, 3}or{pr, es} ES_SCHED_ES(es)==3, ES_SCHED_PR(pr)==0\n");
  printf("    pid>0\n");
  printf("    qid={1, 2, 3, 4, ...}\n");
  printf("    obj... = (obj0, obj1, obj2, obj3, obj4), 0<=obj<=100\n");
  printf("\n");
  printf("  examples: see man %s(1)\n", argv[0]);
  exit(ES_TRUE);
}

int get_status()
{
  if((rtrn=syscall(SYS_ES_NICE, ES_GET_STATUS, &eso))!=ES_TRUE) 
    run_error(rtrn, "ps");

  for (i=0; i< eso.process_no; i++)
  {
    qid[eso.rq_queue_id[i]]=1;
  }
  return ES_TRUE;
}

int run_error(int rtrn, char *fnct)
{
  printf("es: %s: %s\n", fnct, eserr[abs(rtrn)]);
  exit(ES_FAULT);
}

main(int margc, char ** margv)
{
  if((rtrn=check_init(margc, margv))!=ES_TRUE) run_error(rtrn, argv[0]);

  if((rtrn=check_bg())!=ES_TRUE) run_error(rtrn, argv[0]);

  if((rtrn=check_q())!=ES_TRUE) run_error(rtrn, argv[0]);

  if((rtrn=check_po())!=ES_TRUE) run_error(rtrn, argv[0]);

  if((rtrn=check_qo())!=ES_TRUE) run_error(rtrn, argv[0]);

  if((rtrn=check_cq())!=ES_TRUE) run_error(rtrn, argv[0]);

  if((rtrn=check_cp())!=ES_TRUE) run_error(rtrn, argv[0]);

  if((rtrn=check_mp())!=ES_TRUE) run_error(rtrn, argv[0]);

  if((rtrn=check_mq())!=ES_TRUE) run_error(rtrn, argv[0]);

  if((rtrn=check_cpo())!=ES_TRUE) run_error(rtrn, argv[0]);

  if((rtrn=check_cqo())!=ES_TRUE) run_error(rtrn, argv[0]);

  if((rtrn=check_help())!=ES_TRUE) run_error(rtrn, argv[0]);

  if((rtrn=check_info())!=ES_TRUE) run_error(rtrn, argv[0]);

  if((rtrn=check_ver())!=ES_TRUE) run_error(rtrn, argv[0]);

  if((rtrn=check_command())!=ES_TRUE) run_error(rtrn, argv[0]);

  if(strlen(command)>0) 
  {
    if((rtrn=run_command())!=ES_TRUE) run_error(rtrn, argv[0]);
  }

  if(help) 
  {
    if((rtrn=print_help())!=ES_TRUE) run_error(rtrn, argv[0]);
  }
  if(info) 
  {
    if((rtrn=print_info())!=ES_TRUE) run_error(rtrn, argv[0]);
  }
  if(v) 
  {
    if((rtrn=print_ver())!=ES_TRUE) run_error(rtrn, argv[0]);
  }
  if(cp) 
  {
    if((rtrn=run_cp())!=ES_TRUE) run_error(rtrn, argv[0]);
  }
  if(cq) 
  {
    if((rtrn=run_cq())!=ES_TRUE) run_error(rtrn, argv[0]);
  }
  if(cpo) 
  {
    if((rtrn=run_cpo())!=ES_TRUE) run_error(rtrn, argv[0]);
  }
  if(cqo) 
  {
    if((rtrn=run_cqo())!=ES_TRUE) run_error(rtrn, argv[0]);
  }
  if(mp) 
  {
    if((rtrn=run_mp())!=ES_TRUE) run_error(rtrn, argv[0]);
  }
  if(mq) 
  {
    if((rtrn=run_mq())!=ES_TRUE) run_error(rtrn, argv[0]);
  }
  return;
}
