/* read.c - variable assignment reader */

/* Written 1994,1995 by Werner Almesberger */


#include <stdio.h>
#include <string.h>

#include "common.h"
#include "scend.h"
#include "parse.h"
#include "descr.h"


UNUSED *unused = NULL;


void read_cfg(char flags,int record)
{
    UNUSED *n,*last;
    char buffer[MAX_BUFFER+1];
    int off,flag,i,set;
    ITEM *this;

    last = NULL;
    while (next() != EOF) {
	off = 0;
	if (ch == '!') off = 1;
	else back();
	*buffer = 0;
	do {
	    if (strlen(string())+strlen(buffer) > MAX_BUFFER)
		die("MAX_BUFFER exceeded");
	    strcat(buffer,token);
	    if (next() == ':') {
		if (strlen(string())+strlen(buffer)+2 > MAX_BUFFER)
		    die("MAX_BUFFER exceeded");
		strcat(strcat(strcat(buffer,":"),token),"."); /* burn CPU ... */
		next();
	    }
	}
	while (ch == '.');
	if (flag = (ch != '=')) back();
	else {
	    if (off) parse_error("!xxx=yyy ???");
	    string();
	}
	set = 0;
	if (this = lookup(buffer,&i,1))
	    switch (this->type) {
		case it_bool:
		    if (!flag) break;
		    this->u.bool.on = !off;
		    set = 1;
		    break;
		case it_number:
		    if (flag) break;
		    if (!set_field(this,0,token))
			parse_error("invalid number: %s",token);
		    set = 1;
		    break;
		case it_choice:
		    if (flag || i == -1) break;
		    this->u.choice.curr = i;
		    set = 1;
		    break;
		case it_set:
		    if (!flag || i == -1) break;
		    this->u.set.set |= 1 << i;
		    set = 1;
		    break;
		default:
		    ;
	    }
	if (set) this->flags = flags;
	else if (record) {
		n = alloc_t(UNUSED);
		n->var = stralloc(buffer);
		n->value = flag ? NULL : token;
		n->on = !off;
		n->next = NULL;
		if (last) last->next = n;
		else unused = n;
		last = n;
	    }
    }
}
