/* cursed.c - partial (dumb) replacement for curses */

/* Written 1993-1995 by Werner Almesberger */


#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <termios.h>
#include <termcap.h>
#include <signal.h>
#include <sys/ioctl.h>

#include "common.h"
#include "screen.h"
#include "cursed.h"


int LINES = 24;
int COLS = 80;


static struct termios original,current;
static char *cl,*ce,*so,*se,*cm;
static char termcap_area[1024*5];
static int tty;

static volatile int want_resize = 0;


void clear(void)
{
    tputs(cl,1,putchar);
}


void clrtoeol(void)
{
    tputs(ce,1,putchar);
}


void standout(void)
{
    tputs(so,1,putchar);
}


void standend(void)
{
    tputs(se,1,putchar);
}


void move(int y,int x)
{
    tputs(tgoto(cm,x,y),1,putchar);
}


void refresh(void)
{
    fflush(stdout);
}


static void get_size(void)
{
    struct winsize winsz;

    if (ioctl(1,TIOCGWINSZ,&winsz) >= 0) {
	if (winsz.ws_col) COLS = winsz.ws_col;
	if (winsz.ws_row) LINES = winsz.ws_row;
    }
}


static void queue_resize(int sig)
{
    want_resize = 1;
}


void initscr(void)
{
    static char bp[1024];
    struct sigaction sa;
    char *term,*area;

    if (!(term = getenv("TERM")) || tgetent(bp,term) <= 0)
	die("No termcap entry");
    if ((LINES = tgetnum((char *) "li")) < 0) LINES = 24;
    if ((COLS = tgetnum((char *) "co")) < 0) COLS = 80;
    get_size();
    area = termcap_area;
    if (!(cl = tgetstr((char *) "cl",&area)))
	die("Don't know how to clear screen");
    if (!(ce = tgetstr((char *) "ce",&area)))
	die("Don't know how to clear to EOL");
    if (!(so = tgetstr((char *) "so",&area)))
	die("Don't know how to begin standout");
    if (!(se = tgetstr((char *) "se",&area)))
	die("Don't know how to end standout");
    if (!(cm = tgetstr((char *) "cm",&area)))
	die("Don't know how to move cursor");
    tty = tcgetattr(0,&original) >= 0;
    current = original;
    sa.sa_handler = queue_resize;
    sigemptyset(&sa.sa_mask);
    sa.sa_flags = 0;
    sigaction(SIGWINCH,&sa,NULL);
}


void noecho(void)
{
    current.c_lflag &= ~ECHO;
    if (tty) (void) tcsetattr(0,TCSADRAIN,&current);
}


void raw(void)
{
    current.c_lflag &= ~(ICANON | ISIG);
    current.c_cc[VMIN] = 1;
    current.c_cc[VTIME] = 0;
    if (tty) (void) tcsetattr(0,TCSADRAIN,&current);
}


void echo(void)
{
    current.c_lflag |= ECHO;
    if (tty) (void) tcsetattr(0,TCSADRAIN,&current);
}


void noraw(void)
{
    current.c_lflag |= ICANON | ISIG;
    memcpy(&current.c_cc,&original.c_cc,sizeof(cc_t)*NCCS);
    if (tty) (void) tcsetattr(0,TCSADRAIN,&current);
}


void endwin(void)
{
    if (!tty) return;
    (void) tcsetattr(0,TCSADRAIN,&original);
    fflush(stdout);
    /* should release SIGWINCH */
}


int getch(void)
{
    int size;
    char ch;

    if (want_resize) {
	want_resize = 0;
	get_size();
	scr_resize();
	return 0;
    }
    while ((size = read(0,&ch,1)) <= 0)
	if (size < 0)
	    if (errno != EINTR) return EOF;
	    else if (want_resize) return getch();
    return ch;
}
