/* file containing ioctl numbers of ioctls used with USERDEV(0)*/
/**********************************************************************
    Copyright (C) 2002  Hari Krishna Vemuri

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    For any problems contact the author at hkglobalnet@yahoo.com
**********************************************************************/
/*Always include this file after common.h as structure definitions are required*/

# ifndef __USERDEV_IOCTLS_H__
# define __USERDEV_IOCTLS_H__

# include <linux/ioctl.h>

# define USERDEV_IOC_MAGIC	'h'

# define USERDEV_ATTACH 	_IOW(USERDEV_IOC_MAGIC, 0, struct attach_record) /*for attaching to userdev*/
# define USERDEV_DETACH 	_IOW(USERDEV_IOC_MAGIC, 1, struct detach_record) /*for detaching from userdev*/
# define USERDEV_POLL_IN 	_IOW(USERDEV_IOC_MAGIC, 2, int)	/*for intimating arrival of input data to poll operation*/
# define USERDEV_POLL_OUT	_IOW(USERDEV_IOC_MAGIC, 3, int)	/*for intimating arrival of output data to poll operation*/
# define USERDEV_FASYNC_SIGNAL	_IOW(USERDEV_IOC_MAGIC, 4, int)	/*for intimating asynchronous I/O operation*/
# define USERDEV_REQUEST_IRQ	_IOW(USERDEV_IOC_MAGIC, 5, struct irq_request_record)	/*for requesting for interrupt handling*/
# define USERDEV_FREE_IRQ	_IOW(USERDEV_IOC_MAGIC, 6, struct irq_free_record) 	/*for releasing interrupt*/
# define USERDEV_REQUEST_DMA	_IOW(USERDEV_IOC_MAGIC, 7, struct dma_request_record) 	/*for requesting for dma channel*/
# define USERDEV_FREE_DMA	_IOW(USERDEV_IOC_MAGIC, 8, struct dma_free_record) 	/*for releasing dma channel*/
# define USERDEV_START_DMA	_IOW(USERDEV_IOC_MAGIC, 9, struct dma_start_record)	/*for starting dma*/
# define USERDEV_CHECK_DMA	_IOW(USERDEV_IOC_MAGIC, 10, struct dma_check_record)	/*for checking progress of dma operation*/
# define USERDEV_ENABLE_DMA	_IOW(USERDEV_IOC_MAGIC, 11, int)/*for enabling dma operation*/
# define USERDEV_DISABLE_DMA	_IOW(USERDEV_IOC_MAGIC, 12, int)/*for disabling dma operation*/
# define USERDEV_COPY_DMA	_IOW(USERDEV_IOC_MAGIC, 13, struct dma_copy_record)	/*for copying data from dma buffer to user space*/

# endif     /* __USERDEV_IOCTLS_H__ */
