/*file containing declararions for timer queue implementation at user level*/
/**********************************************************************
    Copyright (C) 2002  Hari Krishna Vemuri

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    For any problems contact the author at hkglobalnet@yahoo.com
**********************************************************************/

# ifndef __USERDEV_TIMERQ_H__
# define __USERDEV_TIMERQ_H__

struct userdev_timer_task {			/*each task in timer queue*/
	struct userdev_timer_task* next;	/*pointer to next task*/
	struct userdev_timer_task* prev;	/*pointer to previous task*/
	void (*routine)(unsigned long);	/*task*/
	unsigned long data;		/*parameter for task function*/
	unsigned int expires;		/*expiry time in jiffies*/
};

struct userdev_timer_queue {			/*timer queue data structure*/
	struct userdev_timer_task* first;	/*first task in timer queue*/
	pthread_mutex_t mutex;		/*mutex for accessing queue data structure*/
	int running;			/*flag that denotes if the timer queue is running*/
	pthread_cond_t run_cond;	/*condition variable to sleep if running is false*/
};

void userdev_add_timer(struct userdev_timer_task *tsk);
int userdev_del_timer(struct userdev_timer_task *tsk);
int userdev_mod_timer(struct userdev_timer_task *tsk, unsigned long expires);
int userdev_timer_pending(struct userdev_timer_task *tsk);
void userdev_init_timer_queue(void(*fn)());
unsigned long userdev_get_jiffies();
void userdev_timer_queue_cleanup();

# endif	/*__USERDEV_TIMERQ_H__*/
