/*file containing data structures and functions that keep track of request ids for which signals have arrived*/
/**********************************************************************
    Copyright (C) 2002  Hari Krishna Vemuri

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    For any problems contact the author at hkglobalnet@yahoo.com
**********************************************************************/

# ifndef __USERDEV_SIGLIST_H__
# define __USERDEV_SIGLIST_H__

struct userdev_sig_list {
	struct userdev_sig_list* next;
	int reqid;
};

struct userdev_sig_queue {
	struct userdev_sig_list* first;
	pthread_mutex_t mutex;
};

void userdev_add_sig_list(int);
void userdev_del_sig_list(int);
int userdev_check_sig_list(int);

# endif	/*__USERDEV_SIGLIST_H__*/
