/*file containing implementation of signal list that keeps track of request ids for which signal has been received*/
/**********************************************************************
    Copyright (C) 2002  Hari Krishna Vemuri

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    For any problems contact the author at hkglobalnet@yahoo.com
**********************************************************************/

# include <pthread.h>
# include "siglist.h"

static struct userdev_sig_queue signals = {NULL, PTHREAD_MUTEX_INITIALIZER};

/*
//function to add a node into the list of signal messages arrived given the
//requset id for which the signal has arrived
*/
void userdev_add_sig_list(int reqid)
{
        struct userdev_sig_list *elm;

        pthread_mutex_lock(&signals.mutex);     /*lock for mutual exclusion*/
        elm = (struct userdev_sig_list*)malloc(sizeof(struct userdev_sig_list));
        elm->reqid = reqid;             	/*create a node and store the request id*/
        elm->next = signals.first;         	/*prepend the node to the list of signal messages*/
        signals.first = elm;
        pthread_mutex_unlock(&signals.mutex);   /*unlock*/
}


/*
//function to remove all nodes from the list of signal messages for a
//particular request given its id
*/
void userdev_del_sig_list(int reqid)
{
        struct userdev_sig_list *ptr,*pqr;

        pthread_mutex_lock(&signals.mutex);     /*mutual exclusion lock*/
        ptr = signals.first;       		/*pointer to previous node*/
        pqr = NULL;             		/*pointer to current node*/
        while(ptr!=NULL)
        {
                if(ptr->reqid == reqid)         /*if found match for current*/
                {
                        if(pqr != NULL)         /*check if previous exists*/
                        {
                                pqr->next = ptr->next;  /*if so update previous' next pointer*/
                                free(ptr);
                                ptr = pqr->next;        /*update current pointer to next element to continue search*/
                        }
                        else    /*previous is NULL*/
                        {
                                signals.first = ptr->next; /*update start of list*/
                                free(ptr);
                                ptr = signals.first;	/*set current to start of list*/
                        }
                }
                else    	/*not matching*/
                {
                	pqr = ptr;      	/*update current and previous pointers*/
                	ptr = ptr->next;
                }
        }
        pthread_mutex_unlock(&signals.mutex);   /*unlock*/
}


/*function to check if a signal message has arrived for the given request*/
int userdev_check_sig_list(int reqid)
{
        struct userdev_sig_list *lst = signals.first;

        pthread_mutex_lock(&signals.mutex);     /*lock to prevent changes while searching*/
        while(lst!=NULL)        		/*run though the list and search for a match*/
        {
                if(lst->reqid == reqid)
                {
                        pthread_mutex_unlock(&signals.mutex);   /*unlock*/
                        return 1;       /*if found return 1*/
                }
                lst = lst->next;
        }
        pthread_mutex_unlock(&signals.mutex);   /*unlock*/
        return 0;       		/*not found so return 0*/
}
