/*file contains declarations of data structures and functions that implement block device requests' queue*/
/**********************************************************************
    Copyright (C) 2002  Hari Krishna Vemuri

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    For any problems contact the author at hkglobalnet@yahoo.com
**********************************************************************/

# ifndef __USERDEV_BLK_REQ_H__
# define __USERDEV_BLK_REQ_H__

/*data structure of each node in the request queue*/
struct userdev_blk_request {
	int devid;	/*device id*/
	int command;	/*operation*/
	long sector;	/*starting sector number*/
	int length;	/*number of bytes*/
	int clustersize;/*number of sectors in the current cluster*/
	void* buffer;	/*data buffer*/
	void* buffer_cp;/*a copy of buffer pointer, incase buffer pointer is moved, this pointer gives start of buffer*/
	int size;	/*buffer size*/
	int reqid;	/*userdev request id*/
	pthread_cond_t done_cond;	/*condition variable to signal completion of block transfer*/
	int errors;	/*number of erros encountered serving the request*/
	struct userdev_blk_request *next;	/*pointer to next request*/
};

extern struct userdev_blk_request *rq_head;
# define QUEUE_EMPTY (rq_head == NULL)	/*condition to check if the queue is empty*/
# define CURRENT rq_head		/*pointer to current active request in request queue*/

struct userdev_blk_request* userdev_add_request(int devid, int command, long sector, int length, int clustersize, void *data, int size, int reqid);
void userdev_end_request(int res);
void userdev_blk_requestq_cleanup();

# endif	/*__USERDEV_BLK_REQ_H__*/
