/*
//file containing functions that allow probing of a device connected to the
//parallel port and findout if the device meets IEEE1284 standard
*/
/**********************************************************************
    Copyright (C) 2002  Hari Krishna Vemuri

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    For any problems contact the author at hkglobalnet@yahoo.com
**********************************************************************/

# include <stdio.h>
# include "usrdriv.h"	/*for udelay funciton*/
# include "parport.h"


/* Wait for Status line(s) to change in 35 ms - see IEEE1284-1994 page 24 to
 * 25 for this. After this time we can create a timeout because the
 * peripheral doesn't conform to IEEE1284.  We want to save CPU time: we are
 * waiting a maximum time of 500 us busy (this is for speed).  If there is
 * not the right answer in this time, we schedule other processes
 * are able to eat the time up to 40ms.
 */ 
int parport_wait_peripheral(struct parport *port, unsigned char mask, unsigned char result)
{
	int counter;
	unsigned char status; 
	
	for (counter = 0; counter < 20; counter++)
   	{
		status = parport_read_status(port);
		if ((status & mask) == result)
			return 0;
		userdev_udelay(25);
	}
	usleep(HZ/25 * 10 * 1000);	/* schedule_timeout(HZ/25) =  40ms */
	status = parport_read_status(port);
	return ((status & mask) == result)?0:1;
}		


/* Test if the peripheral is IEEE 1284 compliant.
 * return values are:
 *   0 - handshake failed; peripheral is not compliant (or none present)
 *   1 - handshake OK; IEEE1284 peripheral present but no data available
 *   2 - handshake OK; IEEE1284 peripheral and data available
 */
int parport_ieee1284_nibble_mode_ok(struct parport *port, unsigned char mode) 
{
			/* make sure it's a valid state, set nStrobe & nAutoFeed high */
	parport_frob_control (port, (1|2), 0);
	userdev_udelay(1);
	parport_write_data(port, mode);
	userdev_udelay(400);
			/* nSelectIn high, nAutoFd low */
	parport_frob_control(port, (2|8), 2);
	if (parport_wait_peripheral(port, 0x78, 0x38))
   	{
		parport_frob_control(port, (2|8), 8);
		return 0; 
	}
			/* nStrobe low */
	parport_frob_control (port, 1, 1);
	userdev_udelay(1);	/* Strobe wait */
			/* nStrobe high, nAutoFeed low, last step before transferring reverse data */
	parport_frob_control (port, (1|2), 0);
	userdev_udelay(1);
			/* Data available? */
	parport_wait_peripheral (port, PARPORT_STATUS_ACK, PARPORT_STATUS_ACK);
	return (parport_read_status(port) & PARPORT_STATUS_ERROR)?1:2;
}
