.\" Copyright (c) 1998-2001 Oliver Gantz (Oliver.Gantz@ePost.de)
.\"
.\" This is free documentation; you can redistribute it and/or
.\" modify it under the terms of the GNU General Public License as
.\" published by the Free Software Foundation; either version 2 of
.\" the License, or (at your option) any later version.
.\"
.\" The GNU General Public License's references to "object code"
.\" and "executables" are to be interpreted as the output of any
.\" document formatting or typesetting system, including
.\" intermediate and printed output.
.\"
.\" This manual is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public
.\" License along with this manual; if not, write to the Free
.\" Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
.\" USA.
.TH SRNDT 1 "January 27, 1999" "SRNDT Version 1.0" "SRNDT Surround Tool"
.SH NAME
srndt \- miroMEDIA Surround command line tool
.SH SYNOPSIS
.B srndt
[
.B \-Vh
] [
.BI \-d " device"
] [
.BI \-\-device= device
.RB "] [ " \-\-help " ] [ " \-\-version " ]"
.IR command " [ " arg... " ]"
.SH DESCRIPTION
.B srndt
is a command line tool to control the miroMEDIA Surround Dolby Pro Logic
decoder.
.SS OPTIONS
.TP
.BI \-d " device"
.br
.ns
.TP
.BI \-\-device= device
.br
Specify the name of the
.I device
to use.
.TP
.B \-h
.br
.ns
.TP
.B \-\-help
.br
Print a short help message and exit.
.TP
.B \-V
.br
.ns
.TP
.B \-\-version
.br
Print the version number of
.B srndt
and exit.
.SS COMMANDS
.TP
.B reset
.br
Put the miroMEDIA Surround board to its initial state.
.TP
.BI volume " volume"
.br
Sets the master volume of the Surround board. The value of
.I volume
may range from 0 to 100.
.TP
.B bypass
.IR on | off
.br
Switches the bypass function on or off.
.TP
.B dolby
.IR mode " [" " arg..." " ]"
.br
Turns on a specific Dolby Pro Logic Surround mode. Available modes are:
.br
.RS
.TP
.BI normal " left/right center surround delay"
.br
This mode is for the use of a small center speaker which especially has been
designed to output the dialogs. The values of
.IR left/right , " center" " and" " surround" 
specify the volumes of those channels and may range from 0 to 100.
The value of
.I delay
specifies the delay time between the front and the rear channels. It may
range from 0 (15 milliseconds) to 100 (30 milliseconds).
.TP
.BI wide " left/right center surround delay"
.br
This mode is for the use of a center speaker with performance and frequency
range equal to the left and right speaker.
.TP
.BI phantom " left/right surround delay"
.br
Use this mode if no center speaker is attached.
.TP
.BI 3 " left/right center delay"
.br
This mode is suited best if you attached two front speakers and a center
speaker.
.RE
.SS
.TP
.BI 3d\-phonic " effect level"
.br
Enables a specific 3D-Phonic effect. This emulates a Surround field with
only two speakers in accordance to the JVC standard. Available effects are:
.RS
.TP
.BI standard " level"
.br
This effect offers a spacial sound effect which does not emulate echo effects
in closed rooms. The value of
.I level
specifies the extend to which the effect is applied. It may range from 0 to
100.
.TP
.BI music " level"
.br
This effect is optimally adapted to music and sound programs.
.TP
.BI theater " level"
.br
This offers a room effect especially designed for speech and noise
reproduction.
.TP
.BI strong " level"
.br
This offers a strong spacial sound effect which does not emulate echo effects
in closed rooms.
.TP
.BI theater1 " level"
.br
This offers a strong room effect especially designed for speech and noise
reproduction.
.TP
.BI theater2 " level"
.br
This offers another strong room effect especially designed for speech and noise
reproduction.
.RE
.SS
.TP
.B through
.br
Turns on the through mode which leaves the sound unchanged.
.TP
.B noise
.IR mode " [" " level" " ]"
.br
Turns on the board's internal noise generator. Available modes are:
.RS
.TP
.B off
.br
No noise is generated.
.TP
.BI left " level"
.br
Generates noise on the left channel. The value of
.I level
specifies the level of the generated noise. It may range from 0 to 100.
.TP
.BI center " level"
.br
Generates noise on the center channel.
.TP
.BI right " level"
.br
Generates noise on the right channel.
.TP
.BI surround " level"
.br
Generates noise on the Surround channel.
.RE
.SH FILES
/dev/srnd[0-3]
.SH BUGS
Feel free to report bugs to the author of SRNDT.
.SH AUTHOR
The Linux device driver and this tool for the miroMEDIA Surround board was
written by
.br
Oliver Gantz <Oliver.Gantz@ePost.de>.
.SH "SEE ALSO"
.BR srnd "(4)
