.\" Copyright (c) 1998-2001 Oliver Gantz <Oliver.Gantz@ePost.de>
.\"
.\" This is free documentation; you can redistribute it and/or
.\" modify it under the terms of the GNU General Public License as
.\" published by the Free Software Foundation; either version 2 of
.\" the License, or (at your option) any later version.
.\"
.\" The GNU General Public License's references to "object code"
.\" and "executables" are to be interpreted as the output of any
.\" document formatting or typesetting system, including
.\" intermediate and printed output.
.\"
.\" This manual is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public
.\" License along with this manual; if not, write to the Free
.\" Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
.\" USA.
.TH SRND 4 "January 7, 2001" "SRND Version 1.3" "SRND Device Driver"
.SH NAME
srnd \- miroMEDIA Surround interface
.SH SYNOPSIS
#include <srnd.h>
.SH DESCRIPTION
\fBsrnd[0-3]\fP are character devices for the miroMEDIA Surround
Dolby Pro Logic decoder.
.LP
They are typically created by:
.RS
.sp
mknod -m 666 /dev/srnd0 c 110 0 # first board
.br
mknod -m 666 /dev/srnd1 c 110 1 # second board
.br
mknod -m 666 /dev/srnd2 c 110 2 # third board
.br
mknod -m 666 /dev/srnd3 c 110 3 # fourth board
.sp
.RE
.sp
The following
.IR ioctl (2)
calls are supported:
.IP "\fBint ioctl(int \fP\fIfd\fP\fB, SRNDRESET)\fP"
Resets the Surround board. The bypass function is turned on, the board's
memory is cleared and the volumes of both DACs are set to 16.
.IP "\fBint ioctl(int \fP\fIfd\fP\fB, SRNDVERSION, int *\fP\fIarg\fP\fB)\fP"
Stores the version code of the SRND driver in \fIarg\fP.
.IP "\fBint ioctl(int \fP\fIfd\fP\fB, SRNDDAC_VOL, int \fP\fIarg\fP\fB)\fP"
Sets the volume of both DAC1 and DAC2 to \fIarg\fP. Values from 0 to 16 are
alowed.
.IP "\fBint ioctl(int \fP\fIfd\fP\fB, SRNDDAC1_VOL, int \fP\fIarg\fP\fB)\fP"
Sets the volume of DAC1 to \fIarg\fP. Values from 0 to 16 are alowed.
.IP "\fBint ioctl(int \fP\fIfd\fP\fB, SRNDDAC2_VOL, int \fP\fIarg\fP\fB)\fP"
Sets the volume of DAC2 to \fIarg\fP. Values from 0 to 16 are alowed.
.IP "\fBint ioctl(int \fP\fIfd\fP\fB, SRNDDAC_MUTE, int \fP\fIarg\fP\fB)\fP"
Mutes DAC1 and/or DAC2. Bit 0 of \fIarg\fP=1: mute DAC1, bit 1 of
\fIarg\fP=1: mute DAC2. Call with the appropriate bit set to 0 to unmute.
.IP "\fBint ioctl(int \fP\fIfd\fP\fB, SRNDBYPASS, int \fP\fIarg\fP\fB)\fP"
Turns the bypass function on (\fIarg\fP=1) or off (\fIarg\fP=0).
.IP "\fBint ioctl(int \fP\fIfd\fP\fB, SRNDDBPL_INIT)\fP"
Initializes the Dolby Pro Logic mode.
.IP "\fBint ioctl(int \fP\fIfd\fP\fB, SRNDDBPL_MODE, int \fP\fIarg\fP\fB)\fP"
Turns on a Dolby Pro Logic mode for a specific speaker arrangement.
.br
0: Normal
.br
1: Wide
.br
2: Phantom
.br
3: Dolby 3 Stereo
.IP "\fBint ioctl(int \fP\fIfd\fP\fB, SRNDDBPL_VOL_LR, int \fP\fIarg\fP\fB)\fP"
Sets the volume of the front left and right channels to \fIarg\fP. Values from
0 to 16 are alowed.
.IP "\fBint ioctl(int \fP\fIfd\fP\fB, SRNDDBPL_VOL_C, int \fP\fIarg\fP\fB)\fP"
Sets the volume of the center channel to \fIarg\fP. Values from 0 to 16 are
alowed.
.IP "\fBint ioctl(int \fP\fIfd\fP\fB, SRNDDBPL_VOL_S, int \fP\fIarg\fP\fB)\fP"
Sets the volume of the Surround channel to \fIarg\fP. Values from 0 to 16 are
alowed.
.IP "\fBint ioctl(int \fP\fIfd\fP\fB, SRNDDBPL_DELAY, int \fP\fIarg\fP\fB)\fP"
Sets delay time between the front and rear channels. Values for \fIarg\fP
may range from 0 (= 15 milliseconds) to 15 (= 30 milliseconds).
.IP "\fBint ioctl(int \fP\fIfd\fP\fB, SRND3DPHON_INIT)\fP"
Initializes the 3D-Phonic mode.
.IP "\fBint ioctl(int \fP\fIfd\fP\fB, SRND3DPHON_MODE, int \fP\fIarg\fP\fB)\fP"
Turns on a specific sound effect for the 3D-Phonic mode.
.br
0: Standard
.br
1: Music and Sports
.br
2: Theater
.br
3: Strong
.br
4: Strong Theater 1
.br
5: Strong Theater 2
.IP "\fBint ioctl(int \fP\fIfd\fP\fB, SRND3DPHON_LEVEL, int \fP\fIarg\fP\fB)\fP"
Sets the level of the 3D-Phonic mode to \fIarg\fP. Values from 0 to 15 are
alowed.
.IP "\fBint ioctl(int \fP\fIfd\fP\fB, SRNDTHROUGH_INIT)\fP"
Initializes the Through Stereo mode.
.IP "\fBint ioctl(int \fP\fIfd\fP\fB, SRNDNOISE_INIT)\fP"
Initializes the Noise Generator mode.
.IP "\fBint ioctl(int \fP\fIfd\fP\fB, SRNDNOISE_MODE, int \fP\fIarg\fP\fB)\fP"
Turns on a specific Noise Generator mode.
.br
0: Off
.br
1: Noise on left channel
.br
2: Noise on center channel
.br
3: Noise on right channel
.br
4: Noise on Surround channel
.IP "\fBint ioctl(int \fP\fIfd\fP\fB, SRNDNOISE_LEVEL, int \fP\fIarg\fP\fB)\fP"
Sets the level of the Noise Generator mode to \fIarg\fP. Values from 0 to 9 are
alowed.
.SH FILES
/dev/srnd[0-3]
.SH BUGS
Feel free to report bugs to the author of SRND.
.SH AUTHOR
The Linux device driver for the miroMEDIA Surround board was written by
Oliver Gantz <o.gantz@tu-bs.de>.
.SH "SEE ALSO"
.BR mknod "(1), " ioctl (2)
