/*
    SRND
    
    A driver for the miroMEDIA Surround Dolby Pro Logic decoder.

    Copyright (C) 1998-2001 Oliver Gantz <Oliver.Gantz@ePost.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    ----
    3D-Phonic(R) is a registered trademark of VICTOR COMPANY OF JAPAN, LIMITED.
    DOLBY and PRO LOGIC are trademarks of Dolby Laboratories Licensing Corporation.
    miro(R) is a registered trademark of miro Computer Products AG.
*/


#ifndef _SRND_H
#define _SRND_H

#include <linux/ioctl.h>


#define SRND_VERSION_CODE 0x0103	/* Version 1.3 */



/* IOCTL numbers */

/* IOCTL identifier as described in "ioctl-number.txt" */
/* Should be changed to a unique one.                  */
#define SRND_ID 's'


/* Reset function (just in case...) */
#define SRNDRESET		_IO(SRND_ID,1)

/* Get driver version */
#define SRNDVERSION		_IOR(SRND_ID,2,int)

/* DAC control */
#define SRNDDAC_VOL		_IOW(SRND_ID,3,int)		/* 0 .. 16		*/
#define SRNDDAC1_VOL		_IOW(SRND_ID,4,int)		/* 0 .. 16		*/
#define SRNDDAC2_VOL		_IOW(SRND_ID,5,int)		/* 0 .. 16		*/
#define SRNDDAC_MUTE		_IOW(SRND_ID,6,int)		/* 1 = DAC 1		*/
							/* 2 = DAC 2		*/
							/* 3 = Both DACs	*/

/* Bypass function */
#define SRNDBYPASS		_IOW(SRND_ID,7,int)		/* 0 = Bypass off	*/
							/* 1 = Bypass on	*/  
/* Dolby Pro Logic modes */
#define SRNDDBPL_INIT		_IO(SRND_ID,8)		/* Must be done first	*/
#define SRNDDBPL_MODE		_IOW(SRND_ID,9,int)		/* 0 = Normal		*/
							/* 1 = Wide		*/
							/* 2 = Phantom		*/
							/* 3 = Dolby 3 Stereo	*/

#define SRNDDBPL_VOL_LR		_IOW(SRND_ID,10,int)	/* 0 .. 16		*/
#define SRNDDBPL_VOL_C		_IOW(SRND_ID,11,int)	/* 0 .. 16		*/
#define SRNDDBPL_VOL_S		_IOW(SRND_ID,12,int)	/* 0 .. 16		*/

#define SRNDDBPL_DELAY		_IOW(SRND_ID,13,int)	/* 0 .. 15		*/

/* 3D-Phonic modes */
#define SRND3DPHON_INIT		_IO(SRND_ID,14)		/* Must be done first	*/
#define SRND3DPHON_MODE		_IOW(SRND_ID,15,int)	/* 0 = Standard		*/
							/* 1 = Music and Sports	*/
							/* 2 = Theater		*/
							/* 3 = Strong		*/
							/* 4 = Strong Theater 1	*/
							/* 5 = Strong Theater 2	*/


#define SRND3DPHON_LEVEL	_IOW(SRND_ID,16,int)	/* 0 .. 15		*/


/* Through mode */
#define SRNDTHROUGH_INIT	_IO(SRND_ID,17)		/* Must be done first	*/


/* Noise generator */
#define SRNDNOISE_INIT		_IO(SRND_ID,18)		/* Must be done first	*/
#define SRNDNOISE_MODE		_IOW(SRND_ID,19,int)	/* 0 = Off		*/
							/* 1 = Left		*/
							/* 2 = Center		*/
							/* 3 = Right		*/
							/* 4 = Surround		*/

#define SRNDNOISE_LEVEL		_IOW(SRND_ID,20,int)	/* 0 .. 9		*/


#endif
