%{

/* Parser for a posture definition file */

#include <stdio.h>

int yylex (void);
extern yytext;
extern int lineno;
extern FILE *yyin;

%}

%token NUMBER NAME COMMENT BLOCK_START BLOCK_END THUMB INDEX MIDDLE RING WRIST

%%

posture_def:      posture_name BLOCK_START posture_body BLOCK_END    { printf("parsed posture def\n"); return }
               ;

posture_name:     NAME   { printf("parsed posture name\n"); }
               |  NAME COMMENT    { printf("parsed posture name & comment\n"); }
               ;

posture_body:     posture_data    { printf("parsed posture body\n"); }
               |  posture_data sub_postures    { printf("parsed posture body & sub-postures\n"); }
               ;

sub_postures:     sub_posture
               |  sub_posture sub_postures
               ;

sub_posture:      posture_name BLOCK_START w_data BLOCK_END    { printf("parsed sub-posture\n"); }
               ;

posture_data:     t_data i_data m_data r_data w_data    { printf("parsed posture data\n"); }
               ;

t_data:           THUMB NUMBER NUMBER    { printf("parsed thumb data\n"); }
               ;

i_data:           INDEX NUMBER NUMBER    { printf("parsed index data\n"); }
               ;

m_data:           MIDDLE NUMBER NUMBER   { printf("parsed middle data\n"); }
               ;

r_data:           RING NUMBER NUMBER     { printf("parsed ring data\n"); }
               ;

w_data:           WRIST NUMBER NUMBER    { printf("parsed wrist data\n"); }
               ;

%%

main()
{
  while(!feof(yyin))
    yyparse();

  exit(0);
}

yyerror(char *s)
{
  fprintf(stderr, "%s\n", s);
  exit(1);
}

void *alloca()
{
  printf ("ALLOCA is called !!!\n");
  return 0;
}
