/*
 * message.h
 *
 * (c)3/1/1994 Stuart N. John
 *
 */

#ifndef MESSAGE_H
#define MESSAGE_H


#define MAX(x,y) ((x > y)?(x):(y))


/* message identifiers ( c - client to server )
                       ( s - server to client ) */

typedef enum
{
  PG_GET_GLOVEDATA,    /* c - request latest glove data     */
  PG_SET_CONFIG,       /* c - set config control data       */
  PG_GET_CONFIG,       /* c - request config control data   */
  PG_SET_DATALIST,     /* c - set data list combination     */
  PG_GET_DATALIST,     /* c - request data list combination */
  PG_SET_COMMS,        /* c - set communication mode        */
  PG_GET_COMMS,        /* c - request communcation mode     */
  PG_SET_FILTER,       /* c - set filter mode               */
  PG_GET_FILTER,       /* c - request filter mode           */
  PG_RESET,            /* c - reset config control data     */
  PG_QUIT,             /* c - terminate connection          */
  PG_REPLY_GLOVEDATA,  /* s - send latest glove data        */
  PG_REPLY_CONFIG,     /* s - send config control data      */
  PG_REPLY_DATALIST,   /* s - send data list combination    */
  PG_REPLY_COMMS,      /* s - send communication mode       */
  PG_REPLY_FILTER,     /* s - send filter mode              */
} Msg_id;


/* message header */

/* message id :                                          (char)         */

/* message body */

/* glovedata    : x, y, z, rotation, fingers, keys, tick (G_BYTES*char) */
/* set config   : datalist, comms, filter                (M_BYTES*char) */
/* set datalist : datalist flags                         (char)         */
/* set comms    : comms mode                             (char)         */
/* set filter   : filter mode                            (char)         */


/* functions */

extern int send_message(Msg_id id, int socket, Mode_t *mode, char *data);
extern int get_message (int socket, Mode_t *mode, char *data);

#endif
