/* glove.c
 *
 * (c)3/1/1994 Stuart N. John
 *
 *
 * History:
 *
 *   3-1-1994 - Created module
 *
 */

#include <sys/types.h>

#include "glove.h"


/* global macros */

const u_char FMASK = 0x03;

#define THUMB(f)  (f >> 6 & FMASK)
#define INDEX(f)  (f >> 4 & FMASK)
#define MIDDLE(f) (f >> 2 & FMASK)
#define RING(f)   (f & FMASK)


/*
 * Client functions to retrieve glove data
 *
 */

int getX(Glove_t *glove)
{
  return glove->x;
}

int getY(Glove_t *glove)
{
  return glove->y;
}

int getZ(Glove_t *glove)
{
  return glove->z;
}

int getRotation(Glove_t *glove)
{
  return glove->rotation;
}

Flex getFinger(Glove_t *glove, Fingers finger)
{
  switch (finger)
  {
    case Thumb:  return glove->fingers.thumb;
    case Index:  return glove->fingers.index;
    case Middle: return glove->fingers.middle;
    case Ring:   return glove->fingers.ring;
  }
}

Flex getThumb(Glove_t *glove)
{
  return glove->fingers.thumb;
}

Flex getIndex(Glove_t *glove)
{
  return glove->fingers.index;
}

Flex getMiddle(Glove_t *glove)
{
  return glove->fingers.middle;
}

Flex getRing(Glove_t *glove)
{
  return glove->fingers.ring;
}

int getKey(Glove_t *glove)
{
  return glove->key;
}

int getTime(Glove_t *glove)
{
  return glove->tick;
}


/*
 * Client functions to store raw character glove data
 *
 */

void setX(Glove_t *glove, char x)
{
  glove->x = (int) x;
}

void setY(Glove_t *glove, char y)
{
  glove->y = (int) y;
}

void setZ(Glove_t *glove, char z)
{
  glove->z = (int) z;
}

void setRotation(Glove_t *glove, char rot)
{
  glove->rotation = (int) rot;
}

void setFingers(Glove_t *glove, u_char fingers)
{
  glove->fingers.thumb  = (Flex) THUMB(fingers);
  glove->fingers.index  = (Flex) INDEX(fingers);
  glove->fingers.middle = (Flex) MIDDLE(fingers);
  glove->fingers.ring   = (Flex) RING(fingers);
}

void setKey(Glove_t *glove, u_char key)
{
  glove->key = (int) key;
}

void setTime(Glove_t *glove, char tick)
{
  glove->tick = (int) tick;
}
