 /*iic routines*/

/*i/o used:		parallel printer port for iic bus interface

/*
Not used
scl pull down bit 7 0x378 =pin 9		(d7)				
sda pull down	bit 6 0x378 =pin 8		(d6)	 via si diode, anode on p15
sdain			bit 3 0x379 =pin 15		(!ERROR)
*/

/*
*This one
scl pull down	bit 7 0x378 = pin 7		(d5)	 via si diode, 			
sda pull down	bit 6 0x378 = pin 6		(d4)	 via si diode, anode on p10
sdain			bit 6 0x379 = pin 10	(!ACKN)
*/

#include "eeprog.h"

#define IIC_BUS_DELAY	10	/* micro seconds */
extern int parport_address;

iibeep(da)/*beep and return 0 if error cannot be printed, else return 1*/
int da;/*device address*/
{
int a,i,j;
if((da == 34) || (da == 35)) a = 3;/*txt chip*/
if((da == 68) || (da == 69)) a = 2;/*ctrl chip*/
for(i = 0; i < a; i++)
	{
	usleep(500);
/*	beep(1,4000);
/*	delay(500);
*/   	}
return(1);
}

iicini()
{
sdah();
sclh();
}


//abusdly(int d)
//{
//int i;

//for(i=0;i<d;i++)
//	{
//	d=d;
//	}
//} /* end function busdly */


sdain()
{
register a;
a = inb(parport_address + 1);
a &=  64; /* bit 6 only (!ACK signal on pin 10) */

return(a);
}


iicstart()
{
sdal();
scll();
}


iicstop()
{
sdal();
sclh();
sdah();
}


sndbyte(d)
char d;
/*transmits one byte, scl must be low at start, scl is low at end*/
{
static char a,i;
a=d;
for(i=0;i<8;i++)/*each bit*/
	{
	if(!(a & 128))sdal();/*high bit first*/
	else sdah();
	a+=a;/*a=a*2*/
	sclh();
	scll();
	}
/*read ack bit*/
sdah();
sclh();
a=sdain();
scll();
if(a)return(0);/*no ack slave is error*/
return(1);/*ack slave is ok*/
}


rcvbyte(d,l)
char *d;
char l;/*last byte flag*/
{
static char b,i;
/*if last byte flag, then inverted ack bit is send,
/*scl must be low at start, scl is low at end
*/
sdah();/*for read*/
b=0;
scll();
for(i=0;i<8;i++)
	{
	sclh();
	b+=b;/*shift left*/
	if(sdain())b++;/*set bit 0*/
	scll();
	}
*d = b;
/*send ack bit*/
if(l)sdah();
else sdal();
sclh();
scll();
sdah();
return(1);/*always true, data in *d*/
}


iicsnd(char a, int n, char d[], int er_flag)
/* address, annzahl, data array in ram, error report flag */
{
static int i;

iicstart();
if(!sndbyte(a))
	{
	iicstop();
	if(er_flag)
		{
		fprintf(stderr, "\niicsnd: No ack. device address %u\n", a & 255);
		iibeep(a);
		}

	return(0);
	}
for(i=0;i<n;i++)
	{
	if(!sndbyte(d[i]))
		{
		iicstop();

		if(er_flag)
			{
			fprintf(stderr, "\niicsnd: No ack. data byte %d to device %u\n",d[i], a & 255);
			iibeep(a);
			}

		return(0);
		}
	}

iicstop();
return(1);/*ok*/
}


iicrcv(a,n,d)/*address,anzahl,data ptr to char array*/
char a;
int n;
char *d;
{
static int i;
char t[80];
iicstart();
/*write device address*/
if(!sndbyte(a))
	{
	iicstop();
	fprintf(stderr, "\niicrcv: No ack. device address %u\n", a & 255);
	iibeep(a);
	return(0);
	}
sdah();/*for read*/
for(i=0;i<n-1;i++)
	{
	rcvbyte(&d[i],0);
	}
rcvbyte(&d[i],1);
iicstop();
return(1);
}


scll()
{
register a;
a = inb(parport_address);
a &= ~32; /* reset bit 5 (d5 on pin 7) */
outb(a, parport_address);
busdly(IIC_BUS_DELAY);
}


sclh()
{
register a;
a = inb(parport_address);
a |= 32; /* set bit 5 (d5 on pin 7)*/
outb(a, parport_address);
busdly(IIC_BUS_DELAY);
}


sdal()
{
register a;
a = inb(parport_address);
a &= ~16;/*reset bit 4 (d4 on pin 6)*/
outb(a, parport_address);
busdly(IIC_BUS_DELAY);
}


sdah()
{
register char a;
a = inb(parport_address);
a |= 16; /* set bit 4 (d4 on pin 6)*/
outb(a, parport_address);
busdly(IIC_BUS_DELAY);
}


int busdly(int k)
{      
// Delay at least k microseconds, possibly a good bit more.
// k must be less than 27304.
// Minimum delay on a 25-MHz 386 is about 100 microseconds;
// on a 133-MHz Pentium, about 18 microseconds.

// Uses system timer 2.  
// When running in a DOS box under OS/2, set HW_TIMER ON in DOS settings. 
  
#define IODELAY (inb(0x61))   // allow time for timer to respond
               
unsigned int w;
unsigned char lo,hi;
  
outb( (inb(0x61) & 0xFD) | 1, 0x61);	// spkr off, tmr 2 gate on
w = (unsigned int)(k*1.2);
outb(0xB0, 0x43);						// tmr 2 mode 0 2-byte load
IODELAY;
outb((unsigned char)w, 0x42);			// low byte
IODELAY;
outb((unsigned char)(w>>8), 0x42);		// high byte
IODELAY;
do
	{
	outb(0x80, 0x43);					// latch timer count
	IODELAY;	
	lo = inb(0x42);						// discard low byte
	IODELAY;
	hi = inb(0x42);						// get high byte  
	IODELAY;
	}  
while ((hi & 0x80) == 0);		// wait for a 1 there, signifying rollover

return 1;
} /* end function delay */


