#include "eeprog.h"

extern int debug_flag;


typedef unsigned int  word;

/*
Write one line of Intel-hex file
*/
void write_hex_record(\
	FILE *fp,
	int reclen, /* length (in words) */
	int loc, /* address */
	int *data /* pointer to word data */
	)
{
int check = 0;

if(debug_flag)
	{
	fprintf(stdout,\
	"write_hex_record(): arg fp=%lu reclen=%d loc=%d *data=%lu\n",\
	fp, reclen, loc, data);
	}

//printf("write_hex_record(): arg fp=%d reclen=%d loc=%d *data=%lu\n",\
//fp, reclen, loc, data);

fprintf(fp, ":%02X%04X00", 2 * reclen, 2 * loc);

check += ( (2 * loc) & 0xff) + (((2 * loc) >> 8) & 0xff) + 2 * reclen;

while(reclen--)
	{
	fprintf(fp, "%02X%02X",
	(int)(*data & 0xff), (int)((*data >> 8) & 0xff));
	
	check += (*data & 0xff) + ((*data >> 8) & 0xff);
	data++;
	} /* end while reclen */

/* write checksum, assumes 2-complement */
fprintf(fp, "%02X\n", (-check) & 0xff);
} /* end function write_hex_record */


/*
procedure:
write program memory
write pic id write_hex_record(fp, 4, 0x2000, pic_id);
write config fuses write_hex_record(fp, 1, fuse_address, &config_fuses[0]);
write eeprom 
write end record fputs(":00000001FF\n", fp);
fclose(fp);
*/




