#include "eeprog.h"

typedef unsigned int  word;
typedef unsigned char byte, bit;


// *********************************************************************
// HEX FILE LOADER
// *********************************************************************

// This is for Intel INHX8M (8-bit merged) hex files only.
// These files use two bytes for each word (low, then high).
// All addresses are doubled, i.e., 0x2001 is encoded as 0x4002,
// so that addresses increment at the same rate as the byte count.

int valid_hex_line(char *s)
// Gross syntax and checksum check.
{
byte cksum = 0;                      // For all HEX formats, not just 8M.
int bytecount;
int i, b;

if (s[0] != ':') return(0);          // Initial colon

sscanf(s + 1, "%2x", &bytecount);
if (bytecount > 32) return(0);       // Valid byte count

cksum = bytecount;
i = 3;
bytecount = bytecount + 3;

while (bytecount > 0)
	{
	bytecount--;
	sscanf(s + i, "%2x", &b);
	cksum = cksum + b;                   // Compute checksum
	i = i + 2;
	}

sscanf(s + i, "%2x", &b);

cksum =- cksum;
if (cksum == b) return 1;            // Test checksum

return 0;
} /* end function valid_hex_line */


int load_hex_file(FILE *f, unsigned char buffer[], int length)
{            // Loads a hex file into memory arrays
char s[256];
word i, lo, hi;
word linetype = 0;   // 0 for data, 1 for end of file
word wordcount;      // number of 16 bit words on this line
word address;        // address where they begin
word data[8];        // 16 bytes = 8 words max. per line of hex
int used;
int a;

while((!feof(f)) && (linetype != 1))
	{
    fgets(s, 255, f);

	if(!valid_hex_line(s))
		{			// Syntax check
		s[40] = 0;	// Truncate invalid line for display
		if (s[0] != ':')
			{
       		printf("Invalid line (skipped): '%s'...\n",s);
       	 	continue;
     		}
		else
			{
    	    printf("Unable to decode line:  '%s'...\n",s);
			return 0;
			}
		}

	sscanf(s + 1, "%2x", &wordcount);      // Parse the line - Intel Hex8M
//	wordcount = wordcount / 2;           // (double bytes, addresses doubled)

	sscanf(s + 3, "%4x", &address);
//	address = address / 2;

	sscanf(s + 7, "%2x", &linetype);

	if(linetype == 1) return 1;

	/* grab the data */
	for (i = 0; i < wordcount; i++)
		{
		sscanf(s + (9 + (2 * i) ), "%2x",\
		&buffer[address + i]);

//printf("WAS address=%04x data=%02x\n", address + i, buffer[address + i]);

//usleep(100000);

		} /* end for i */

	} /* end while data */

return 1;
} /* end function load_hex_file */

